package com.tydic.dyc.agr.model.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.*;
import com.tydic.dyc.agr.repository.AgrAgrRepository;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 标题:IAgrAgrModelImpl
 * 说明:TODO
 * 时间:2022/8/23 15:26
 * 作者:代愿愿
 */
@Service
public class IAgrAgrModelImpl implements IAgrAgrModel {

    @Autowired
    private AgrAgrRepository agrAgrRepository;

    @Override
    public void updateAgrMain(AgrAgrDo agrAgrDo) {
        //参数验证
        this.validation(agrAgrDo);
        //协议主体修改
        agrAgrRepository.updateAgrMain(agrAgrDo);
    }

    /**
     * 协议主体修改方法参数验证
     *
     * @param agrAgrDo
     */
    private void validation(AgrAgrDo agrAgrDo) {
        if (agrAgrDo == null || agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    @Override
    public void createAgr(AgrAgrDo agrAgrDo) {
        if(agrAgrDo.getAgrId()==null){
            agrAgrDo.setAgrId(IdUtil.nextId());
        }
        if(ObjectUtil.isEmpty(agrAgrDo.getAgrVersion())){
            agrAgrDo.setAgrVersion("test_ver");
        }
        if(ObjectUtil.isEmpty(agrAgrDo.getAgrStatus())){
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        }
        //协议主体新增
        agrAgrRepository.saveAgrMain(agrAgrDo);
        //协议子实体新增
        agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    @Override
    public void updateAgr(AgrAgrDo agrAgrDo) {
        //入参校验
        this.validateAgrMain(agrAgrDo);
        //修改协议主体
        this.agrAgrRepository.updateAgrMain(agrAgrDo);
        //删除协议子实体
        this.agrAgrRepository.deleteAgrSub(agrAgrDo);
        //新增协议子实体
        this.agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    @Override
    public AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo) {
        //协议主体查询
        return this.agrAgrRepository.getAgrMain(agrAgrQryBo);
    }

    @Override
    public void deleteAgr(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        //协议主体删除
        this.agrAgrRepository.deleteAgrMain(agrAgrDo);
    }

    @Override
    public AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo) {
        //协议详情查询
        return this.agrAgrRepository.getAgrDetail(agrAgrQryBo);
    }

    @Override
    public AgrItemListQryRspPageBo getAgrItemList(AgrItemListQryReqPageBo agrItemListQryReqPageBo) {
        //协议明细列表查询
        return this.agrAgrRepository.getAgrItemtList(agrItemListQryReqPageBo);
    }

    @Override
    public void saveAgrItem(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            if (ObjectUtil.isEmpty(agrAgrDo.getAgrId())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
            }
        }
        //新增协议明细
        this.agrAgrRepository.saveAgrItem(agrAgrDo);

    }

    @Override
    public void updateAgrItem(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null || CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        //批量删除协议明细
        this.agrAgrRepository.deleteAgrItemByBatch(agrAgrDo);
        //新增协议明细
        this.agrAgrRepository.saveAgrItem(agrAgrDo);
    }

    @Override
    public void deleteAgrItemByBatch(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        //批量删除协议明细
        this.agrAgrRepository.deleteAgrItemByBatch(agrAgrDo);

    }

    @Override
    public void updateAgrItemByBatch(AgrAgrDo param0) {
        if (param0.getAgrId() == null || CollectionUtils.isEmpty(param0.getAgrItem())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        this.agrAgrRepository.updateAgrItemByBatch(param0);

    }

    @Override
    public AgrGetAllAgrListRspBO getAllAgrList() {
        //数据同步: 查询协议列表
        return this.agrAgrRepository.getAllAgrList();
    }

    @Override
    public void saveAgrAllocateRecord(AgrAgrDo agrAgrDo) {
        //入参检验
        this.validateAllocatrRecord(agrAgrDo);
        //新增协议分配记录
        this.agrAgrRepository.saveAgrAllocateRecord(agrAgrDo);
    }

    @Override
    public AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo) {
        //协议分配记录列表查询
        return this.agrAgrRepository.getAgrAllocateRecordList(agrAgrQryBo);
    }

    @Override
    public AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo) {
        //协议主体列表查询
        return this.agrAgrRepository.getAgrMainList(agrAgrQryBo);
    }

    @Override
    public AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCount(AgrGetAgrItemCountByCommodityTypeReqPageBo reqPageBo) {
        return this.agrAgrRepository.getAgrItemCountByCommodityType(reqPageBo);
    }

    @Override
    public void saveAgrVersion(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.saveAgrVersion(agrAgrDo);
    }

    @Override
    public AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo) {
        return this.agrAgrRepository.getAgrVersionList(agrGetAgrVersionListReqBo);
    }

    @Override
    public void saveAgrHis(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.saveAgrHis(agrAgrDo);
    }

    /**
     * 协议修改方法参数校验
     *
     * @param agrAgrDo
     */
    private void validateAgrMain(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isEmpty(agrAgrDo)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    /**
     * 分配记录參數校驗
     *
     * @param agrAgrDo
     */
    private void validateAllocatrRecord(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrAllocateRecord())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        agrAgrDo.getAgrAllocateRecord().forEach(agrAllocateRecord -> {
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorIdOld())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[原协议经办人ID]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorNameOld())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[原协议经办人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorUsernameOld())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[原协议经办人用户名]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorId())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议经办人ID]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorName())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议经办人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorUsername())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议经办人用户名]不能为空");
            }
        });
    }


}

