package com.tydic.dyc.agr.model.procinst.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTodoQryBo;
import com.tydic.dyc.agr.repository.AgrProcInstRepository;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 标题:IAgrProcInstModelImpl
 * 说明:TODO
 * 时间:2022/8/24 10:13
 * 作者:王洪港
 */
@Service
public class IAgrProcInstModelImpl implements IAgrProcInstModel {

    @Autowired
    private AgrProcInstRepository agrProcInstRepository;

    @Override
    public AgrProcInstDo getTaskList(AgrTaskQryBo param0) {
        //入参校验
        validateAgrTask(param0);
        return agrProcInstRepository.getTaskList(param0);
    }

    private void validateAgrTask(AgrTaskQryBo agrTaskQryBo){
        if (ObjectUtil.isEmpty(agrTaskQryBo)){
            throw new BaseBusinessException("0001", "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrTaskQryBo.getOrderId())){
            throw new BaseBusinessException("0001", "入参对象属性[订单id]不能为空");
        }
    }

    @Override
    public void updateTask(AgrProcInstDo agrProcInstDo) {
        // 必填校验
        if(agrProcInstDo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参agrUocOrderTaskInst不能为空");
        }
        agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
            if(uocOrderTaskInst.getOrderId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参orderId不能为空");
            }
            if(uocOrderTaskInst.getObjId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参objId不能为空");
            }
            if(StringUtils.isEmpty(uocOrderTaskInst.getTaskInstId())){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参taskInstId不能为空");
            }
        });
        agrProcInstRepository.updateTask(agrProcInstDo);

    }

    @Override
    public AgrProcInstDo getProcInst(AgrProcInstDo agrProcInstDo) {
        if(agrProcInstDo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(StringUtils.isEmpty(agrProcInstDo.getProcInstId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参procInstId不能为空");

        }
        return agrProcInstRepository.getProInst(agrProcInstDo);
    }

    @Override
    public void saveProcInst(AgrProcInstDo agrProcInstDo) {
        if(agrProcInstDo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(StringUtils.isEmpty(agrProcInstDo.getProcInstId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参procInstId不能为空");

        }
        if(agrProcInstDo.getObjId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参objId不能为空");

        }
        if(agrProcInstDo.getOrderId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参orderId不能为空");

        }
        if(agrProcInstDo.getObjType()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参ObjType不能为空");

        }
        agrProcInstDo.setOperTime(new Date());
        agrProcInstRepository.saveProcInst(agrProcInstDo);
    }

    @Override
    public void saveTask(AgrProcInstDo agrProcInstDo) {
        if(agrProcInstDo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参agrUocOrderTaskInst不能为空");
        }
        agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
            if(StringUtils.isEmpty(uocOrderTaskInst.getProcInstId())){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参procInstId不能为空");
            }
            if(StringUtils.isEmpty(uocOrderTaskInst.getTaskInstId())){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参taskInstId不能为空");
            }
            if(uocOrderTaskInst.getObjId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参objId不能为空");

            }
            if(uocOrderTaskInst.getOrderId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参orderId不能为空");

            }
            if(uocOrderTaskInst.getObjType()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参ObjType不能为空");

            }
        });
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskDeal())){
            agrProcInstDo.getAgrUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                if(StringUtils.isEmpty(uocOrderTaskDeal.getTaskInstId())){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参taskInstId不能为空");
                }
                if(uocOrderTaskDeal.getObjId()==null){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参objId不能为空");

                }
                if(uocOrderTaskDeal.getOrderId()==null){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参orderId不能为空");

                }
                if(uocOrderTaskDeal.getObjType()==null){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参ObjType不能为空");

                }
                if(StringUtils.isEmpty(uocOrderTaskDeal.getDealId())){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参dealId不能为空");
                }
                if(StringUtils.isEmpty(uocOrderTaskDeal.getDealName())){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参dealName不能为空");
                }
            });
        }
        agrProcInstDo.setOperTime(new Date());
        agrProcInstRepository.saveTask(agrProcInstDo);
    }

    @Override
    public void updateTaskDeal(AgrProcInstDo agrProcInstDo) {
        if(agrProcInstDo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskDeal())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参agrUocOrderTaskDeal不能为空");
        }
        agrProcInstDo.getAgrUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
            if(StringUtils.isEmpty(uocOrderTaskDeal.getTaskInstId())){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参taskInstId不能为空");
            }
            if(uocOrderTaskDeal.getObjType()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参ObjType不能为空");
            }
            if(StringUtils.isEmpty(uocOrderTaskDeal.getDealId())){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参dealId不能为空");
            }
            if(StringUtils.isEmpty(uocOrderTaskDeal.getDealName())){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参dealName不能为空");
            }
            if(uocOrderTaskDeal.getObjId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参objId不能为空");

            }
            if(uocOrderTaskDeal.getOrderId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参orderId不能为空");

            }
        });
        agrProcInstRepository.updateTaskDeal(agrProcInstDo);
    }

    @Override
    public void deleteTask(AgrProcInstDo agrProcInstDo) {
        if(agrProcInstDo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参agrUocOrderTaskInst不能为空");
        }
        agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
            if(uocOrderTaskInst.getObjId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参objId不能为空");
            }
            if(uocOrderTaskInst.getOrderId()==null){
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参orderId不能为空");
            }
        });
        agrProcInstRepository.deleteTask(agrProcInstDo);
    }

    @Override
    public void saveTaskLog(AgrProcInstDo agrProcInstDo) {

    }

    @Override
    public void getTaskDeal(AgrProcInstDo agrProcInstDo) {

    }

    @Override
    public AgrProcInstDo getTodoList(AgrTodoQryBo agrTodoQryBo) {
        return agrProcInstRepository.getTodoList(agrTodoQryBo);
    }

    @Override
    public void saveTodo(AgrProcInstDo agrProcInstDo) {
        agrProcInstRepository.saveTodo(agrProcInstDo);
    }

    @Override
    public void updateTodo(AgrProcInstDo agrProcInstDo) {
        agrProcInstRepository.updateTodo(agrProcInstDo);
    }
}
