package com.tydic.dyc.agr.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrItemByBatchService;
import com.tydic.dyc.agr.service.agr.bo.AgrUccSyncAgrItemStatusBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemByBatchReqBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public class AgrUccSyncAgrItemStatusConsumer extends DefaultProxyMessageConfig implements ProxyMessageConsumer {
    @Autowired
    private AgrUpdateAgrItemByBatchService agrUpdateAgrItemByBatchService;
    /**
     * 明细状态同步
     * @param message
     * @return
     */
    @Override
    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("商品同步协议message=" + JSON.toJSONString(message));
        String content = message.getContent();
        log.info("商品同步协议消费者收到，数据内容如下" + content);
        AgrUccSyncAgrItemStatusBo agrUccSyncAgrItemStatusBo =JSON.parseObject(message.getContent(), new TypeReference<AgrUccSyncAgrItemStatusBo>() {});
        if(agrUccSyncAgrItemStatusBo.getAgreementSkuStatus().equals(AgrCommConstant.SkuStatus.DRAFT)){
            AgrUpdateAgrItemByBatchReqBO agrUpdateAgrItemByBatchReqBO = new AgrUpdateAgrItemByBatchReqBO();
            agrUpdateAgrItemByBatchReqBO.setAgrId(agrUccSyncAgrItemStatusBo.getAgreementId());
            agrUpdateAgrItemByBatchReqBO.setAgrItemIds(agrUccSyncAgrItemStatusBo.getAgreementSkuIds());
            agrUpdateAgrItemByBatchReqBO.setAgrSkuStatus(agrUccSyncAgrItemStatusBo.getAgreementSkuStatus());
            this.agrUpdateAgrItemByBatchService.updateAgrItemByBatch(agrUpdateAgrItemByBatchReqBO);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}
