package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 作者: dmc
 * 时间: 2022/8/24 11:51
 * 描述:
 */
@HTServiceImpl
public class AgrDeleteAgrServiceImpl implements AgrDeleteAgrService{

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public AgrDeleteAgrRspBo deleteAgr(AgrDeleteAgrReqBo reqBo) {
        //1 参数校验
        this.validationParam(reqBo);
        //2 调用协议删除方法
        this.agrAgrModel.deleteAgr(AgrRu.js(reqBo, AgrAgrDo.class));

        return AgrRu.success(AgrDeleteAgrRspBo.class);
    }

    /**
     * 入参校验
     * @param reqBo reqBo
     */
    private void validationParam(AgrDeleteAgrReqBo reqBo){
        if (reqBo == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[协议ID]不能为空");
        }
    }
}
