package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngAccessory;
import com.tydic.dyc.agr.service.agrchange.bo.AgrChngAccessoryBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 作者: dmc
 * 时间: 2022/9/9 16:06
 * 描述:
 */
@HTServiceImpl
@Slf4j
public class AgrGetAgrChngApplyDetailServiceImpl implements AgrGetAgrChngApplyDetailService {

    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrGetAgrChngApplyDetailRspBO getAgrChngApplyDetail(AgrGetAgrChngApplyDetailReqBO reqBO) {
        //1 入参校验
        this.validationParam(reqBO);
        //2 调用协议变更申请详情查询方法
        AgrChngApplyDo agrChngApplyDo = iAgrChngApplyModel.getAgrChngApplyDetail(AgrRu.js(reqBO, AgrAgrChngApplyQryBo.class));
        //3 封装出参
        return typeEscape(agrChngApplyDo);
    }

    /**
     * 类型转义
     * @param agrChngApplyDo agrChngApplyDo
     * @return AgrGetAgrChngApplyDetailRspBO
     */
    private AgrGetAgrChngApplyDetailRspBO typeEscape(AgrChngApplyDo agrChngApplyDo){
        AgrGetAgrChngApplyDetailRspBO rspBO =  AgrRu.js(agrChngApplyDo,AgrGetAgrChngApplyDetailRspBO.class);
        if(agrChngApplyDo.getChngApplyId()!=null){
            //变更类型转义
            rspBO.setChngTypeStr(AgrCommConstant.AgrChngTypeEnum.getValueByCode(rspBO.getChngType()));
            //变更申请状态转义
            rspBO.setChngApplyStatusStr(AgrCommConstant.ChngApplyStatusEnum.getValueByCode(AgrRu.parseInteger(rspBO.getChngApplyStatus())));
            List<AgrChngAccessory> agrChngAccessory = agrChngApplyDo.getAgrChngAccessory();
            rspBO.setAgrChngAccessory(AgrRu.jsl(agrChngAccessory, AgrChngAccessoryBo.class));
        }
        return rspBO;
    }
    /**
     * 入参检验
     * @param reqBO reqBO
     */
    private void validationParam(AgrGetAgrChngApplyDetailReqBO reqBO){
        if(ObjectUtil.isEmpty(reqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getAgrId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[协议ID]不能为空");
        }
        if(ObjectUtil.isEmpty(reqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[协议变更申请ID]不能为空");
        }
    }
}
