package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrProcInsTerminateReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrProcInsTerminateRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrProcInsTerminateServiceImpl
 * 说明:TODO
 * 时间:2022/9/5 19:58
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrProcInsTerminateServiceImpl implements AgrProcInsTerminateService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrProcInsTerminateRspBO dealProcInsTerminate(AgrProcInsTerminateReqBO reqBO) {
        AgrProcInstDo agrProcInstDo = this.getProcInst(reqBO.getProcInstId());
        if(agrProcInstDo.getObjType().equals(AgrCommConstant.ObjType.AGREEMENT)){
            // 处理新增审批通过
            this.dealAgrCreateAuditPass(agrProcInstDo);
        }else if(agrProcInstDo.getObjType().equals(AgrCommConstant.ObjType.CHANGE)){
            // 处理变更审批通过
            this.dealAgrChangAuditPass(agrProcInstDo);
        }
        AgrProcInsTerminateRspBO rspBO = AgrRu.success(AgrProcInsTerminateRspBO.class);
        rspBO.setObjId(agrProcInstDo.getObjId());
        rspBO.setOrderId(agrProcInstDo.getOrderId());
        rspBO.setPickerConfigNo(agrProcInstDo.getObjType().toString());
        return rspBO;
    }
    /**
     * 处理变更审批通过
     */
    private void dealAgrChangAuditPass(AgrProcInstDo agrProcInstDo){

    }
    /**
     * 处理协议创建审批通过
     */
    private void dealAgrCreateAuditPass(AgrProcInstDo agrProcInstDo){
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrProcInstDo.getObjId());
        agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        iAgrAgrModel.updateAgrMain(agrAgrDo);
    }
    /**
     * 查询流程信息
     */
    private AgrProcInstDo getProcInst(String procInstId){
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo() ;
        agrProcInstDo.setProcInstId(procInstId);
        AgrProcInstDo agrProcInstRspDo = iAgrProcInstModel.getProcInst(agrProcInstDo);
        if(null == agrProcInstRspDo){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_QUERY_NOT_EXIST_ERROR, "流程信息不存在");
        }
        return agrProcInstRspDo;
    }
}
