/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.repository.AgrAgrChngRepository;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrGetAgrAddChngPreItemListService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAddChngPreItemListReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAddChngPreItemListRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrGetAgrAddChngPreItemListService"})
public class AgrGetAgrAddChngPreItemListServiceImpl
implements AgrGetAgrAddChngPreItemListService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrAddChngPreItemListServiceImpl.class);
    @Autowired
    private AgrAgrChngRepository agrAgrChngRepository;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"getAgrAddChngPreItemList"})
    public AgrGetAgrAddChngPreItemListRspBO getAgrAddChngPreItemList(@RequestBody AgrGetAgrAddChngPreItemListReqBO reqBo) {
        this.validation(reqBo);
        List<Long> agrItemIds = this.getAgrItemChngList(reqBo);
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBo, AgrItemListQryReqPageBo.class);
        agrItemListQryReqPageBo.setNotAgrItemIds(agrItemIds);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        AgrGetAgrAddChngPreItemListRspBO rspBO = AgrRu.js(agrItemListQryRspPageBo, AgrGetAgrAddChngPreItemListRspBO.class);
        return rspBO;
    }

    private List<Long> getAgrItemChngList(AgrGetAgrAddChngPreItemListReqBO reqBo) {
        List<AgrItemChng> agrItemChngs;
        AgrItemChngListQryReqPageBo agrItemChngListQryReqPageBo = (AgrItemChngListQryReqPageBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), AgrItemChngListQryReqPageBo.class);
        agrItemChngListQryReqPageBo.setItemChngType(AgrCommConstant.AgreementSkuChangeType.DELETE);
        AgrItemChngListQryRspPageBo agrItemChngListQryRspPageBo = this.agrAgrChngRepository.getAgrItemChngList(agrItemChngListQryReqPageBo);
        ArrayList<Long> agrItemIds = new ArrayList<Long>();
        if (ObjectUtil.isNotEmpty((Object)agrItemChngListQryRspPageBo) && !CollectionUtils.isEmpty(agrItemChngs = agrItemChngListQryRspPageBo.getRows())) {
            agrItemChngs.stream().map(AgrItemChng::getAgrItemId).forEach(agrItemId -> agrItemIds.add((Long)agrItemId));
        }
        return agrItemIds;
    }

    private void validation(AgrGetAgrAddChngPreItemListReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getChngApplyId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d8\u66f4\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPageNo())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5f53\u524d\u9875]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPageSize())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6bcf\u9875\u6761\u6570]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

