/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrProcInsTerminateService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrProcInsTerminateReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrProcInsTerminateRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrProcInsTerminateService"})
public class AgrProcInsTerminateServiceImpl
implements AgrProcInsTerminateService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealProcInsTerminate"})
    public AgrProcInsTerminateRspBO dealProcInsTerminate(@RequestBody AgrProcInsTerminateReqBO reqBO) {
        AgrProcInstDo agrProcInstDo = this.getProcInst(reqBO.getProcInstId());
        if (agrProcInstDo.getObjType().equals(AgrCommConstant.ObjType.AGREEMENT)) {
            this.dealAgrCreateAuditPass(agrProcInstDo);
        } else if (agrProcInstDo.getObjType().equals(AgrCommConstant.ObjType.CHANGE)) {
            this.dealAgrChangAuditPass(agrProcInstDo);
        }
        AgrProcInsTerminateRspBO rspBO = AgrRu.success(AgrProcInsTerminateRspBO.class);
        rspBO.setObjId(agrProcInstDo.getObjId());
        rspBO.setOrderId(agrProcInstDo.getOrderId());
        rspBO.setPickerConfigNo(agrProcInstDo.getObjType().toString());
        return rspBO;
    }

    private void dealAgrChangAuditPass(AgrProcInstDo agrProcInstDo) {
    }

    private void dealAgrCreateAuditPass(AgrProcInstDo agrProcInstDo) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrProcInstDo.getObjId());
        agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }

    private AgrProcInstDo getProcInst(String procInstId) {
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setProcInstId(procInstId);
        AgrProcInstDo agrProcInstRspDo = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (null == agrProcInstRspDo) {
            throw new BaseBusinessException("22001", "\u6d41\u7a0b\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return agrProcInstRspDo;
    }
}

