/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.utils;

import com.tydic.dyc.base.exception.BaseBusinessException;

public class IdUtil {
    private static final long START = 1420041600000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static long workerId = 0L;
    private static long dataCenterId = 0L;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;

    public static synchronized long nextId() {
        long timestamp = IdUtil.timeGen();
        if (workerId == 0L) {
            workerId = (int)(Math.random() * 10.0);
        }
        if (timestamp < lastTimestamp) {
            throw new BaseBusinessException("\u5931\u8d25", String.format("\u751f\u6210ID\u5e76\u53d1\u65f6\u95f4\u5c0f\u4e8e\u9600\u503c.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = IdUtil.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 22 | dataCenterId << 17 | workerId << 12 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = IdUtil.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = IdUtil.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }
}

