/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService;
import com.tydic.dyc.agr.service.agr.bo.AgrAccessoryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCataScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainExtBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrRelBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService"})
public class AgrGetAgrDetailServiceImpl
implements AgrGetAgrDetailService {
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @PostMapping(value={"getAgrDetail"})
    public AgrGetAgrDetailRspBo getAgrDetail(@RequestBody AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        this.validationParam(agrGetAgrDetailReqBo);
        AgrAgrQryBo agrAgrQryBo = AgrRu.js(agrGetAgrDetailReqBo, AgrAgrQryBo.class);
        AgrAgrDo agrDetail = this.agrAgrModel.getAgrDetail(agrAgrQryBo);
        AgrGetAgrDetailRspBo rspBo = this.setRspBoInfo(agrDetail);
        if (agrDetail != null) {
            rspBo.setProcInstId(this.qryProInstId(agrDetail.getAgrId()));
        }
        return rspBo;
    }

    private void validationParam(AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        if (agrGetAgrDetailReqBo.getAgrId() == null && StringUtils.isEmpty((Object)agrGetAgrDetailReqBo.getAgrCode())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrId]\u548c\u534f\u8bae\u7f16\u53f7[agrCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private String qryProInstId(Long agrId) {
        String procInstId = null;
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjId(agrId);
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.AGREEMENT);
        agrAuditOrderQryBo.setOrderId(agrId);
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if (!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())) {
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setOrderId(agrId);
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }

    public AgrGetAgrDetailRspBo setRspBoInfo(AgrAgrDo agrDetail) {
        AgrGetAgrDetailRspBo rspBo = new AgrGetAgrDetailRspBo();
        if (agrDetail != null) {
            AgrAdjustCfg agrAdjustCfg;
            AgrMainDetailBo agrMainBO = AgrRu.js(agrDetail, AgrMainDetailBo.class);
            AgrMainDetailBo agrMain = this.agrMainTransferredMeaning(agrMainBO);
            rspBo.setAgrMainSaveBO(agrMain);
            rspBo.setAgrAppScopeBOs(AgrRu.jsl(agrDetail.getAgrAppScope(), AgrAppScopeBo.class));
            rspBo.setAgrAccessoryBOs(AgrRu.jsl(agrDetail.getAgrAccessory(), AgrAccessoryBo.class));
            rspBo.setAgrCataScopeBOs(AgrRu.jsl(agrDetail.getAgrCataScope(), AgrCataScopeBo.class));
            List<AgrPayConfig> agrPayConfig = agrDetail.getAgrPayConfig();
            if (!agrPayConfig.isEmpty()) {
                for (AgrPayConfig item : agrPayConfig) {
                    AgrPayConfigDetailBo payConfigDetailBo = AgrRu.js(item, AgrPayConfigDetailBo.class);
                    if (ObjectUtil.isNotEmpty((Object)payConfigDetailBo.getAssign())) {
                        if (item.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())) {
                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.NoAssign.getValueByCode((Integer)payConfigDetailBo.getBusiNode()));
                        } else if (item.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.IsAssign.getValueByCode((Integer)payConfigDetailBo.getBusiNode()));
                        }
                    }
                    payConfigDetailBo.setPayTypeStr(AgrCommConstant.PayTypeEnum.getValueByCode((Integer)payConfigDetailBo.getPayType()));
                    if (AgrCommConstant.payObj.PAY_OBJ_PURCHASE.equals(item.getPayObj())) {
                        payConfigDetailBo.setPayObjStr(AgrCommConstant.PayObjEnum.getValueByCode((Integer)item.getPayObj()));
                        rspBo.getAgrMainSaveBO().setPayTypePur(payConfigDetailBo);
                    }
                    if (AgrCommConstant.payObj.PAY_OBJ_SUPPLY.equals(item.getPayObj())) {
                        payConfigDetailBo.setPayObjStr(AgrCommConstant.PayObjEnum.getValueByCode((Integer)item.getPayObj()));
                        rspBo.getAgrMainSaveBO().setPayTypeSup(payConfigDetailBo);
                    }
                    if (rspBo.getAgrMainSaveBO().getPayTypePur() == null) {
                        rspBo.getAgrMainSaveBO().setPayTypePur(new AgrPayConfigDetailBo());
                    }
                    if (rspBo.getAgrMainSaveBO().getPayTypeSup() != null) continue;
                    rspBo.getAgrMainSaveBO().setPayTypeSup(new AgrPayConfigDetailBo());
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(agrAdjustCfg = agrDetail.getAgrAdjustCfg()))) {
                rspBo.getAgrMainSaveBO().setWhetherAddPrice(agrAdjustCfg.getWhetherAddPrice());
                rspBo.getAgrMainSaveBO().setMarkupRate(agrAdjustCfg.getMarkupRate());
                rspBo.getAgrMainSaveBO().setWhetherAdjustPriceFormula(agrAdjustCfg.getWhetherAdjustPriceFormula());
                rspBo.getAgrMainSaveBO().setWhetherModifyBuyPrice(agrAdjustCfg.getWhetherModifyBuyPrice());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaId(agrAdjustCfg.getAdjustPriceFormulaId());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaName(agrAdjustCfg.getAdjustPriceFormulaName());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaValue(agrAdjustCfg.getAdjustPriceFormulaValue());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormula(agrAdjustCfg.getAdjustPriceFormula());
            }
            List<AgrRel> agrRel = agrDetail.getAgrRel();
            rspBo.setAgrRel(AgrRu.jsl(agrRel, AgrRelBo.class));
            List<AgrMainExt> agrMainExt = agrDetail.getAgrMainExt();
            List<AgrMainExtBo> agrMainExtBos = AgrRu.jsl(agrMainExt, AgrMainExtBo.class);
            rspBo.getAgrMainSaveBO().setAgrMainExtBOs(agrMainExtBos);
        }
        return rspBo;
    }

    private AgrMainDetailBo agrMainTransferredMeaning(AgrMainDetailBo rspBo) {
        if (rspBo.getAgrMode() != null) {
            rspBo.setAgrModeStr(AgrCommConstant.AgreementModeEnum.getValueByCode((Integer)rspBo.getAgrMode()));
        }
        if (rspBo.getAgrType() != null) {
            rspBo.setAgrTypeStr(AgrCommConstant.AgrTypeEnum.getValueByCode((Integer)rspBo.getAgrType()));
        }
        if (rspBo.getAgrStatus() != null) {
            rspBo.setAgrStatusStr(AgrCommConstant.AgreementStatusEnum.getNameByValue((Integer)rspBo.getAgrStatus()));
        }
        if (rspBo.getAgrPriceType() != null) {
            rspBo.setAgrPriceTypeStr(AgrCommConstant.AgrPriceTypeEnum.getValueByCode((Integer)rspBo.getAgrPriceType()));
        }
        if (rspBo.getAgrSrc() != null) {
            rspBo.setAgrSrcStr(AgrCommConstant.AgrSrcEnum.getValueByCode((Integer)rspBo.getAgrSrc()));
        }
        if (rspBo.getTradeMode() != null) {
            rspBo.setTradeModeStr(AgrCommConstant.TradeModeEnum.getValueByCode((Integer)rspBo.getTradeMode()));
        }
        if (rspBo.getWhetherDispatch() != null) {
            rspBo.setWhetherDispatchStr(AgrCommConstant.WhetherDispatchEnum.getValueByCode((Integer)rspBo.getWhetherDispatch()));
        }
        if (rspBo.getWhetherAssign() != null) {
            rspBo.setWhetherAssignStr(AgrCommConstant.WhetherAssignEnum.getValueByCode((Integer)rspBo.getWhetherAssign()));
        }
        if (rspBo.getAgreementVariety() != null) {
            rspBo.setAgreementVarietyStr(AgrCommConstant.AgreementVarietyEnum.getValueByCode((Integer)rspBo.getAgreementVariety()));
        }
        if (rspBo.getAgrLocation() != null) {
            rspBo.setAgrLocationStr(AgrCommConstant.AgrLocationEnum.getValueByCode((Integer)rspBo.getAgrLocation()));
        }
        if (rspBo.getWhetherStorePlan() != null) {
            rspBo.setWhetherStorePlanStr(AgrCommConstant.WhetherStorePlanEnum.getValueByCode((Integer)rspBo.getWhetherStorePlan()));
        }
        if (rspBo.getScopeType() != null) {
            rspBo.setScopeTypeStr(AgrCommConstant.ScopeTypeEnum.getValueByCode((Integer)rspBo.getScopeType()));
        }
        if (rspBo.getAdjustPrice() != null) {
            rspBo.setAdjustPriceStr(AgrCommConstant.AdjustPriceEnum.getValueByCode((Integer)rspBo.getAdjustPrice()));
        }
        if (rspBo.getWhetherHaveItem() != null) {
            rspBo.setWhetherHaveItemStr(AgrCommConstant.WhetherHaveItemEnum.getValueByCode((Integer)rspBo.getWhetherHaveItem()));
        }
        return rspBo;
    }
}

