/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrAgrChngSupComfirmService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrChngSupComfirmReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrChngSupComfirmRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrAgrChngSupComfirmService"})
public class AgrAgrChngSupComfirmServiceImpl
implements AgrAgrChngSupComfirmService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"dealAgrChngSupComfirm"})
    public AgrAgrChngSupComfirmRspBO dealAgrChngSupComfirm(@RequestBody AgrAgrChngSupComfirmReqBO reqBO) {
        this.validParam(reqBO);
        this.invokeUpdateTask(reqBO);
        this.invokeUpdateAgrChngApply(reqBO);
        return AgrRu.success(AgrAgrChngSupComfirmRspBO.class);
    }

    private void invokeUpdateAgrChngApply(AgrAgrChngSupComfirmReqBO reqBO) {
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setConfirmName(reqBO.getName());
        agrChngApplyDo.setConfirmTime(new Date());
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }

    private void invokeUpdateTask(AgrAgrChngSupComfirmReqBO reqBO) {
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        ArrayList<UocOrderTaskInst> agrUocOrderTaskInsts = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBO.getChngApplyId());
        uocOrderTaskInst.setOrderId(reqBO.getAgrId());
        uocOrderTaskInst.setTaskInstId(reqBO.getTaskId());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getName());
        uocOrderTaskInst.setDealResult(reqBO.getConfirmResult());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.taskFinishFLag.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        agrUocOrderTaskInsts.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInsts);
        this.iAgrProcInstModel.updateTask(agrProcInstDo);
    }

    private void validParam(AgrAgrChngSupComfirmReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2agrId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmResult() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2confirmResult\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getChngApplyId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2chngApplyId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

