package com.tydic.dyc.agr.model.auditorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.repository.AgrAuditOrderRepository;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class IAgrAuditOrderModelImpl implements IAgrAuditOrderModel {
    @Autowired
    AgrAuditOrderRepository agrAuditOrderRepository;

    @Override
    public void createAuditOrder(AgrAuditOrderDo agrAuditOrderDo) {
        //1 参数校验
        this.validateAuditOrder(agrAuditOrderDo);

        // 2 保存审批单数据
        this.agrAuditOrderRepository.saveAuditOrder(agrAuditOrderDo);

    }

    @Override
    public AgrAuditOrderDo getAuditObj(AgrAuditOrderQryBo agrAuditOrderQryBo) {
        return this.agrAuditOrderRepository.getAuditObj(agrAuditOrderQryBo);
    }
    /**
     * 参数校验
     */
    private void validateAuditOrder(AgrAuditOrderDo agrAuditOrderDo) {
        if (ObjectUtil.isEmpty(agrAuditOrderDo.getAuditOrderId())) {
            long agrId = IdUtil.nextId();
            agrAuditOrderDo.setAuditOrderId(agrId);
        }
        if (ObjectUtil.isEmpty(agrAuditOrderDo.getAuditOrderStatus())) {
            //设置默认的审批状态
            agrAuditOrderDo.setAuditOrderStatus(AgrCommConstant.AUDIT_ORDER_STATUS.WAIT_AUDIT);
        }
    }


}
