package com.tydic.dyc.agr.service.agrchange;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrGetAgrChngCodeServiceImpl
 * 说明:TODO
 * 时间:2022/9/7 14:07
 * 作者:代愿愿
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrChngCodeServiceImpl implements AgrGetAgrChngCodeService {
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public AgrGetAgrChngCodeRspBO getAgrChngCode(AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO) {
        //1 入参校验
        this.validation(agrGetAgrChngCodeReqBO);
        //2 组装编码生成服务入参
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = this.packageEncodeParams(agrGetAgrChngCodeReqBO);
        //3 调用编码获取服务
        log.debug("获取协议变更编码入参="+encodedSerialGetServiceReqBO);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        log.debug("获取协议变更编码出参="+encodedSerialGetServiceRspBO);
        //4 组装出参
        return packageGinseng(encodedSerialGetServiceRspBO);
    }

    /**
     * 组装出参
     * @param encodedSerialGetServiceRspBO encodedSerialGetServiceRspBO
     * @return AgrGetAgrChngCodeRspBO
     */
    private AgrGetAgrChngCodeRspBO packageGinseng(CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO){
        String chngApplyNo="";
        //定义出参
        AgrGetAgrChngCodeRspBO agrGetAgrChngCodeRspBO = new AgrGetAgrChngCodeRspBO();
        if(encodedSerialGetServiceRspBO != null){
            List<String> serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
            if(!CollectionUtils.isEmpty(serialNoList)){
                chngApplyNo = serialNoList.get(0);
                agrGetAgrChngCodeRspBO.setChngApplyNo(chngApplyNo);
            }
        }
        agrGetAgrChngCodeRspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        agrGetAgrChngCodeRspBO.setChngApplyId(IdUtil.nextId());
        return agrGetAgrChngCodeRspBO;
    }
    /**
     * 设置编码获取服务入参
     * @param agrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO
     * @return CfcEncodedSerialGetServiceReqBO
     */
    private CfcEncodedSerialGetServiceReqBO packageEncodeParams(AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        if(null != agrGetAgrChngCodeReqBO.getChangeType()){
            switch(agrGetAgrChngCodeReqBO.getChangeType()){
                case 1: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_ZT"); break;
                case 2: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_QY"); break;
                case 3: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_ZZ"); break;
                case 4: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_TJ"); break;
                case 5: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_YQ"); break;
                case 6: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_BG"); break;
                case 7: encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_QT"); break;
                default:;
            }
        }
        List<String> replaceValueList = new ArrayList<>();
        replaceValueList.add(agrGetAgrChngCodeReqBO.getPlaAgreementCode());
        encodedSerialGetServiceReqBO.setCenter("AGR");
        encodedSerialGetServiceReqBO.setReplaceValue(replaceValueList);
        return encodedSerialGetServiceReqBO;
    }

    /**
     * 入参校验
     * @param agrGetAgrChngCodeReqBO
     */
    private void validation(AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO) {
        if (agrGetAgrChngCodeReqBO == null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参[agrGetAgrChngCodeReqBO]不能为空");
        }
        if (agrGetAgrChngCodeReqBO.getChangeType() == null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参[changeType]不能为空");
        }
        if (agrGetAgrChngCodeReqBO.getPlaAgreementCode() == null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参[plaAgreementCode]不能为空");
        }
    }
}
