package com.tydic.dyc.agr.service.procinst;

import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTodoQryBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTodoListReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTodoListRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocTodoBo;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题:AgrGetTodoListServiceImpl
 * 说明:TODO
 * 时间:2022/11/22 10:31
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetTodoListServiceImpl implements AgrGetTodoListService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Override
    public AgrGetTodoListRspBO getTodoList(AgrGetTodoListReqBO agrGetTodoListReqBO) {
        AgrGetTodoListRspBO rspBO = AgrRu.success(AgrGetTodoListRspBO.class);
        AgrTodoQryBo agrTodoQryBo = AgrRu.js(agrGetTodoListReqBO,AgrTodoQryBo.class);
        AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTodoList(agrTodoQryBo);
        if(agrProcInstDo!=null && !CollectionUtils.isEmpty(agrProcInstDo.getAgrUocTodo())){
            List<AgrUocTodoBo> agrUocTodo = AgrRu.jsl(agrProcInstDo.getAgrUocTodo(),AgrUocTodoBo.class);
            rspBO.setAgrUocTodo(agrUocTodo);
        }
        return rspBO;
    }
}

