package com.tydic.dyc.agr.mq;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description 明细状态同步消费者配置类
 * @author Luokan
 * @date 2019-10-14 3:28 PM
 *
 * LM商城逻辑
 * LM商城逻辑
 **/
@Configuration
public class AgrUccSyncAgrItemStatusConsumerConfiguration {
    @Value("${UCC_AUDIT_NOTIFY_NEW_CID}")
    private String uccSyncAgrCid;

    @Value("${UCC_AUDIT_NOTIFY_NEW_TOPIC}")
    private String uccSyncAgrTopic;

    @Value("${UCC_AUDIT_NOTIFY_NEW_TAG}")
    private String uccSyncAgrTag;


    @Bean("agrUccSyncAgrItemStatusConsumer")
    public AgrUccSyncAgrItemStatusConsumer agrUccSyncAgrItemStatusConsumer(){
        AgrUccSyncAgrItemStatusConsumer agrUccSyncAgrItemStatusConsumer =
                new AgrUccSyncAgrItemStatusConsumer();
        agrUccSyncAgrItemStatusConsumer.setId(uccSyncAgrCid);
        agrUccSyncAgrItemStatusConsumer.setSubject(uccSyncAgrTopic);
        String[] tags = {uccSyncAgrTag};
        agrUccSyncAgrItemStatusConsumer.setTags(tags);
        return  agrUccSyncAgrItemStatusConsumer;
    }

}
