package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrHisCreateReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrHisCreateRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrAgrHisCreateServiceImpl
 * 说明:TODO
 * 时间:2022/10/17 16:07
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrHisCreateServiceImpl implements AgrAgrHisCreateService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrAgrHisCreateRspBO saveAgrHis(AgrAgrHisCreateReqBO agrAgrHisCreateReqBO) {
        // 1 入参校验
        this.validateParam(agrAgrHisCreateReqBO);
        // 2 调用协议日志新增方法
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrAgrHisCreateReqBO.getAgrId());
        this.iAgrAgrModel.saveAgrHis(agrAgrDo);
        AgrAgrHisCreateRspBO rspBO = AgrRu.success(AgrAgrHisCreateRspBO.class);
        return rspBO;
    }
    /**
     * 入参校验
     */
    private void validateParam(AgrAgrHisCreateReqBO agrAgrHisCreateReqBO){
        if (ObjectUtil.isEmpty(agrAgrHisCreateReqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (agrAgrHisCreateReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]不能为空");
        }
    }
}
