package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.impl.IAgrAgrModelImpl;
import com.tydic.dyc.agr.model.agr.sub.*;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @desc:
 * @author: PingZi
 * @date: 2022/8/24 11:45
 */
@HTServiceImpl
public class AgrCreateAgrServiceImpl implements AgrCreateAgrService{

    @Autowired
    private IAgrAgrModelImpl iAgrAgrModel;

    @Override
    public AgrCreateAgrRspBo createAgr(AgrCreateAgrReqBo reqBo) {
        //1 参数校验
        this.validateParams(reqBo);
        //2 设置创建信息
        AgrAgrDo agrAgrDo = this.setCreationInformation(reqBo);
        //3 调用协议新增方法
        this.iAgrAgrModel.createAgr(agrAgrDo);
        //4 新增协议明细信息
        if(!CollectionUtils.isEmpty(reqBo.getAgrItem())){
            AgrAgrDo agrAgrDo1 = JSONObject.parseObject(JSON.toJSONString(reqBo), AgrAgrDo.class);
            agrAgrDo1.setAgrId(agrAgrDo.getAgrId());
            this.iAgrAgrModel.saveAgrItem(agrAgrDo1);
        }
        AgrCreateAgrRspBo rspBo = AgrRu.success(AgrCreateAgrRspBo.class);
        //5 返回协议id信息
        rspBo.setAgrId(agrAgrDo.getAgrId());
        return rspBo;
    }

    /**
     * 设置协议创建入参
     * @param reqBo reqBo
     * @return AgrAgrDo
     */
    private AgrAgrDo setCreationInformation(AgrCreateAgrReqBo reqBo){
        //基本信息设置
        AgrAgrDo agrAgrDo = JSONObject.parseObject(JSON.toJSONString(reqBo.getAgrMainSaveBO()), AgrAgrDo.class);
        agrAgrDo.setOperTime(new Date());
        agrAgrDo.setUserId(reqBo.getUserId());
        agrAgrDo.setUsername(reqBo.getUsername());
        agrAgrDo.setName(reqBo.getName());
        agrAgrDo.setOrgId(reqBo.getOrgId());
        agrAgrDo.setOrgName(reqBo.getOrgName());
        agrAgrDo.setVendorMode(reqBo.getAgrMainSaveBO().getSupplierMode());
        agrAgrDo.setOrgPath(reqBo.getOrgPath());
        agrAgrDo.setAgrAccessory(AgrRu.jsl(reqBo.getAgrAccessoryBOs(), AgrAccessory.class));
        //设置协议应用范围
        agrAgrDo.setAgrAppScope(AgrRu.jsl(reqBo.getAgrAppScopeBOs(), AgrAppScope.class));
        agrAgrDo.setAgrCataScope(AgrRu.jsl(reqBo.getAgrCataScopeBOs(), AgrCataScope.class));
        // 设置协议支付配置
        List<AgrPayConfig> agrPayConfigList = new ArrayList<>();
        //判断供应商是否为空
        if (ObjectUtil.isNotEmpty(reqBo.getAgrMainSaveBO().getPayTypeSup()) && ObjectUtil.isNotEmpty(reqBo.getAgrMainSaveBO().getPayTypeSup().getPayType())){
            AgrPayConfig agrPayConfig = AgrRu.js(reqBo.getAgrMainSaveBO().getPayTypeSup(),AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_SUPPLY);
            agrPayConfigList.add(agrPayConfig);
        }
        //判断采购商是否为空
        if (ObjectUtil.isNotEmpty(reqBo.getAgrMainSaveBO().getPayTypePur()) && ObjectUtil.isNotEmpty(reqBo.getAgrMainSaveBO().getPayTypePur().getPayType())){
            AgrPayConfig agrPayConfig = AgrRu.js(reqBo.getAgrMainSaveBO().getPayTypePur(),AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_PURCHASE);
            agrPayConfigList.add(agrPayConfig);
        }
        agrAgrDo.setAgrPayConfig(agrPayConfigList);
        //设置协议调价配置
        AgrAdjustCfg agrAdjustCfg = new AgrAdjustCfg();
        agrAdjustCfg.setAdjustPrice(reqBo.getAgrMainSaveBO().getAdjustPrice());
        agrAgrDo.setAgrAdjustCfg(agrAdjustCfg);

        //设置外部关联配置
        List<AgrRel> agrRels = new ArrayList<>();
        if(ObjectUtil.isNotEmpty(reqBo.getAgrRel())){
            reqBo.getAgrRel().forEach(r -> {
                AgrRel agrRel = AgrRu.js(r, AgrRel.class);
                agrRels.add(agrRel);
            });
            agrAgrDo.setAgrRel(agrRels);
        }
        return agrAgrDo;
    }

    /**
     * 入参校验
     * @param reqBo reqBo
     */
    private void validateParams(AgrCreateAgrReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo.getAgrMainSaveBO())) {
            throw new BaseBusinessException("", "入参对象[协议主体信息]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgrMainSaveBO().getAgrCode())) {
            throw new BaseBusinessException("", "入参对象属性[协议编号]不能为空");
        }
    }
}
