package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.impl.IAgrAgrModelImpl;
import com.tydic.dyc.agr.model.agr.sub.*;
import com.tydic.dyc.agr.service.agr.bo.AgrMainSaveBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author 王洪港
 * @date 2022-08-24 11:40
 **/
@HTServiceImpl
public class AgrUpdateAgrServiceImpl implements AgrUpdateAgrService{

    @Autowired
    private IAgrAgrModelImpl iAgrAgrModel;

    /**
     * 协议修改服务
     */
    @Override
    public AgrUpdateAgrRspBo updateAgr(AgrUpdateAgrReqBo agrUpdateAgrReqBo) {
        //1 参数校验
        this.validateUpdateAgr(agrUpdateAgrReqBo);
        //2 封装数据
        AgrAgrDo agrAgrDo = this.packagingData(agrUpdateAgrReqBo);
        //3 调用协议修改方法
        this.iAgrAgrModel.updateAgr(agrAgrDo);

        return AgrRu.success(AgrUpdateAgrRspBo.class);
    }

    /**
     * 协议修改服务入参校验
     */
    private void validateUpdateAgr(AgrUpdateAgrReqBo agrUpdateAgrReqBo){
        if (ObjectUtil.isEmpty(agrUpdateAgrReqBo)){
            throw new BaseBusinessException("0001", "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateAgrReqBo.getAgrAppScopeBOs())){
            throw new BaseBusinessException("0001", "入参对象属性[应用范围信息]不能为空");
        }
    }

    /**
     * 封装数据
     */
    private AgrAgrDo packagingData(AgrUpdateAgrReqBo agrReqBo){

        //1 设置协议主体
        AgrAgrDo agrAgrDo = AgrRu.js(agrReqBo.getAgrMainSaveBO(),AgrAgrDo.class);
        //设置用户ID
        agrAgrDo.setUserId(agrReqBo.getUserId());
        //设置用户名称
        agrAgrDo.setName(agrReqBo.getName());
        //设置用户账号
        agrAgrDo.setUsername(agrReqBo.getUsername());
        //设置更新时间
        agrAgrDo.setOperTime(new Date());
        //协议id
        agrAgrDo.setAgrId(agrReqBo.getAgrId());
        //2 设置协议外部关联
        // TODO

        //3 设置协议类目范围
        List<AgrCataScope> agrCataScopeList = AgrRu.jsl(agrReqBo.getAgrCataScopeBOs(), AgrCataScope.class);
        agrAgrDo.setAgrCataScope(agrCataScopeList);

        //4 设置协议支付配置
        List<AgrPayConfig> agrPayConfigList = new ArrayList<>();
        //判断供应商是否为空
        if (ObjectUtil.isNotEmpty(agrReqBo.getAgrMainSaveBO().getPayTypeSup()) && ObjectUtil.isNotEmpty(agrReqBo.getAgrMainSaveBO().getPayTypeSup().getPayType())){
            AgrPayConfig agrPayConfig = AgrRu.js(agrReqBo.getAgrMainSaveBO().getPayTypeSup(),AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_SUPPLY);
            agrPayConfigList.add(agrPayConfig);
        }
        //判断采购商是否为空
        if (ObjectUtil.isNotEmpty(agrReqBo.getAgrMainSaveBO().getPayTypePur()) && ObjectUtil.isNotEmpty(agrReqBo.getAgrMainSaveBO().getPayTypePur().getPayType())){
            AgrPayConfig agrPayConfig = AgrRu.js(agrReqBo.getAgrMainSaveBO().getPayTypePur(),AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_PURCHASE);
            agrPayConfigList.add(agrPayConfig);
        }
        agrAgrDo.setAgrPayConfig(agrPayConfigList);

        //5 设置协议应用范围
        List<AgrAppScope> agrAppScopeList = AgrRu.jsl(agrReqBo.getAgrAppScopeBOs(), AgrAppScope.class);
        agrAgrDo.setAgrAppScope(agrAppScopeList);

        //6 设置附件信息
        List<AgrAccessory> agrAccessoryList = AgrRu.jsl(agrReqBo.getAgrAccessoryBOs(), AgrAccessory.class);
        agrAgrDo.setAgrAccessory(agrAccessoryList);

        //7 设置协议调价配置
        AgrAdjustCfg agrAdjustCfg = new AgrAdjustCfg();
        agrAdjustCfg.setAdjustPrice(agrReqBo.getAgrMainSaveBO().getAdjustPrice());
        agrAgrDo.setAgrAdjustCfg(agrAdjustCfg);

        return agrAgrDo;
    }
}
