package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.service.agrchange.bo.AgrDeleteAgrChngApplyReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrDeleteAgrChngApplyRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Author: dmc
 * @Date: 2022/9/22 15:03
 * @Description:
 */
@HTServiceImpl
@Slf4j
public class AgrDeleteAgrChngApplyServiceImpl implements AgrDeleteAgrChngApplyService{

    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrDeleteAgrChngApplyRspBO deleteAgrChngApply(AgrDeleteAgrChngApplyReqBO reqBO) {
        //1 入参校验
        this.validationParam(reqBO);
        //2 组装入参
        AgrChngApplyDo agrChngApplyDo = AgrRu.js(reqBO, AgrChngApplyDo.class);
        //删除协议变更申请
        this.iAgrChngApplyModel.deleteChngApply(agrChngApplyDo);

        return AgrRu.success(AgrDeleteAgrChngApplyRspBO.class);
    }

    /**
     * 入参校验
     */
    private void validationParam(AgrDeleteAgrChngApplyReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }
}
