package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAddChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAddChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrAgrAddChngAuditCallBackServiceImpl
 * 说明:TODO
 * 时间:2022/9/23 13:02
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrAddChngAuditCallBackServiceImpl implements AgrAgrAddChngAuditCallBackService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrAgrAddChngAuditCallBackRspBO dealAddChngAuditCallBack(AgrAgrAddChngAuditCallBackReqBO reqBO) {
        // 1 调用变更申请状态变更
        this.invokeUpdateAgrChngApplyMain(reqBO);
        // 2 修改明细相关信息
        this.syncAgrItem(reqBO);
        return AgrRu.success(AgrAgrAddChngAuditCallBackRspBO.class);
    }
    /**
     * 协议明细修改
     */
    private void syncAgrItem(AgrAgrAddChngAuditCallBackReqBO reqBO){
        // 1 查询协议明细变更列表
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(reqBO.getAgrId());
        reqPageBo.setChngApplyId(reqBO.getChngApplyId());
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if(rspPageBo.getTotal()>0){
            int total = rspPageBo.getTotal();
            for (int i=1;i<=total;i++){
                reqPageBo.setPageNo(i);
                reqPageBo.setPageSize(1000);
                AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                List<AgrItemChng> addAgrItemChngs = new ArrayList<>();
                List<AgrItemChng> deleteAgrItemChngs = new ArrayList<>();
                rspPageBo1.getRows().forEach(agrItemChng -> {
                    if(agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.ADD)){
                        addAgrItemChngs.add(agrItemChng);
                    }
                    if(agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.DELETE)){
                        deleteAgrItemChngs.add(agrItemChng);
                    }
                });
                // 新增协议明细
                this.insertAgrItem(addAgrItemChngs,reqBO.getAgrId());
                // 删除协议明细
                this.deleteAgrItem(deleteAgrItemChngs,reqBO.getAgrId());
            }
        }
    }
    /**
     * 新增协议明细
     */
    private void insertAgrItem(List<AgrItemChng> agrItemChngs,Long agrId){
        if(!CollectionUtils.isEmpty(agrItemChngs)){
            AgrAgrDo agrAgrDo = new AgrAgrDo();
            agrAgrDo.setAgrId(agrId);
            List<AgrItem> agrItem = JSON.parseArray(JSON.toJSONString(agrItemChngs),AgrItem.class);
            agrAgrDo.setAgrItem(agrItem);
            this.iAgrAgrModel.saveAgrItem(agrAgrDo);
        }
    }
    /**
     * 删除协议明细
     */
    private void deleteAgrItem(List<AgrItemChng> agrItemChngs,Long agrId){
        if(!CollectionUtils.isEmpty(agrItemChngs)){
            AgrAgrDo agrAgrDo = new AgrAgrDo();
            agrAgrDo.setAgrId(agrId);
            List<AgrItem> agrItems = new ArrayList<>();
            List<Long> agrItemIds = new ArrayList<>();
            agrItemChngs.forEach(agrItemChng -> {
                agrItemIds.add(agrItemChng.getAgrItemId());
            });
            AgrItem agrItem = new  AgrItem();
            agrItem.setAgrId(agrId);
            agrItem.setAgrItemIds(agrItemIds);
            agrItems.add(agrItem);
            agrAgrDo.setAgrItem(agrItems);
            this.iAgrAgrModel.deleteAgrItemByBatch(agrAgrDo);
        }

    }
    /**
     * 调用变更申请状态变更
     */
    private void invokeUpdateAgrChngApplyMain(AgrAgrAddChngAuditCallBackReqBO reqBO){
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}
