package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSupComfirmAgrReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSupComfirmAgrRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrSupComfirmAgrServiceImpl
 * 说明:TODO
 * 时间:2022/9/1 17:27
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrSupComfirmAgrServiceImpl implements AgrSupComfirmAgrService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrSupComfirmAgrRspBO dealSupComfirm(AgrSupComfirmAgrReqBO reqBO) {
        // 1 必填校验
        this.validParam(reqBO);
        // 2 调用任务提交
        this.invokeUpdateTask(reqBO);
        // 3 修改协议主体的确认时间
        this.invokeUpdateAgrMain(reqBO);
        return AgrRu.success(AgrSupComfirmAgrRspBO.class);
    }
    /**
     * 修改协议主体的确认时间
     */
    private void invokeUpdateAgrMain(AgrSupComfirmAgrReqBO reqBO){
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(reqBO.getAgrId());
        agrAgrDo.setConfirmTime(new Date());
        agrAgrDo.setConfirmName(reqBO.getName());
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }
    /**
     * 任务提交
     */
    private void invokeUpdateTask(AgrSupComfirmAgrReqBO reqBO){
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        List<UocOrderTaskInst> agrUocOrderTaskInsts = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBO.getAgrId());
        uocOrderTaskInst.setOrderId(reqBO.getAgrId());
        uocOrderTaskInst.setTaskInstId(reqBO.getTaskId());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getName());
        uocOrderTaskInst.setDealResult(reqBO.getConfirmResult());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.taskFinishFLag.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        agrUocOrderTaskInsts.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInsts);
        iAgrProcInstModel.updateTask(agrProcInstDo);

    }
    /**
     * 必填校验
     */
    private void validParam(AgrSupComfirmAgrReqBO reqBO){
        if(reqBO==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(reqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参agrId不能为空");
        }
        if(reqBO.getConfirmResult()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参confirmResult不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getTaskId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参taskId不能为空");
        }
    }
}
