package com.tydic.dyc.agr.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqSyncSkuStatusMqServiceConfiguration {

    @Value("${AGR_SKU_CHANGE_PID}")
    private String agrSkuChangePid;

    @Bean(value="agrSyncSkuStatusMqServiceProvider", initMethod = "startup", destroyMethod = "shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean(){
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(agrSkuChangePid);
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig(defaultProxyMessageConfig);
        return proxyProducerFactoryBean;
    }
}
