package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrCopyReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCopyRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:AgrCopyServiceImpl
 * 说明:TODO
 * 时间:2022/9/22 14:12
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrCopyServiceImpl implements AgrCopyService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrCopyRspBO dealAgrCopy(AgrCopyReqBO agrCopyReqBO) {
        // 1 入参校验
        this.validateParam(agrCopyReqBO);
        // 2 根据入参中的协议ID查询协议详情
        AgrAgrDo agrAgrDetailDo = this.getAgrDetail(agrCopyReqBO.getAgrId());
        // 3 调用协议新增方法
        this.createAgr(agrAgrDetailDo,agrCopyReqBO);
        // 4 复制协议明细
        this.copyAgrItem(agrCopyReqBO.getAgrId(),agrAgrDetailDo.getAgrId());

        AgrCopyRspBO rspBO = AgrRu.success(AgrCopyRspBO.class);
        rspBO.setAgrId(agrAgrDetailDo.getAgrId());
        return rspBO;
    }
    /**
     * 复制协议
     */
    private void createAgr(AgrAgrDo agrAgrDetailDo,AgrCopyReqBO agrCopyReqBO){
        agrAgrDetailDo.setOperTime(new Date());
        agrAgrDetailDo.setUserId(agrCopyReqBO.getUserId());
        agrAgrDetailDo.setUsername(agrCopyReqBO.getUsername());
        agrAgrDetailDo.setName(agrCopyReqBO.getName());
        agrAgrDetailDo.setOrgId(agrCopyReqBO.getOrgId());
        agrAgrDetailDo.setOrgName(agrCopyReqBO.getOrgName());
        agrAgrDetailDo.setAgrCode(agrCopyReqBO.getAgrCode());
        agrAgrDetailDo.setAgrId(IdUtil.nextId());
        agrAgrDetailDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        this.iAgrAgrModel.createAgr(agrAgrDetailDo);
    }
    /**
     * 复制明细数据
     */
    private void copyAgrItem(Long agrIdOld, Long agrIdNew){
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrId(agrIdOld);
        // 1 先按每次1000条复制，先查有多少页
        agrItemListQryReqPageBo.setOrderBy("agr_item_id");
        agrItemListQryReqPageBo.setPageNo(1);
        agrItemListQryReqPageBo.setPageSize(1000);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        if(!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())){
            this.saveAgrItem(agrIdNew,agrItemListQryRspPageBo.getRows());
            // 如果明细数据不止一页
            if(agrItemListQryRspPageBo.getTotal()>1){
                int total = agrItemListQryRspPageBo.getTotal();
                for (int i=2;i<=total;i++){
                    agrItemListQryReqPageBo.setPageNo(i);
                    agrItemListQryReqPageBo.setPageSize(1000);
                    AgrItemListQryRspPageBo agrItemListQryRspPageBo1 = iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
                    this.saveAgrItem(agrIdNew,agrItemListQryRspPageBo1.getRows());
                }
            }
        }

    }
    /**
     * 新增协议明细
     */
    private void saveAgrItem(Long agrIdNew, List<AgrItem> agrItems){
        agrItems.forEach(agrItem -> {
            agrItem.setAgrItemId(null);
        });
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrIdNew);
        agrAgrDo.setAgrItem(agrItems);
        this.iAgrAgrModel.saveAgrItem(agrAgrDo);
    }

    /**
     * 协议详情查询
     */
    private AgrAgrDo getAgrDetail(Long agrId){
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo() ;
        agrAgrQryBo.setAgrId(agrId);
        return this.iAgrAgrModel.getAgrDetail(agrAgrQryBo);

    }
    /**
     * 入参校验
     */
    private void validateParam(AgrCopyReqBO agrCopyReqBO){
        if (ObjectUtil.isEmpty(agrCopyReqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (agrCopyReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]不能为空");
        }
        if(StringUtils.isEmpty(agrCopyReqBO.getAgrCode())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrCode]不能为空");
        }
    }
}
