package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@HTServiceImpl
public class AgrCreateAgrItemServiceImpl implements AgrCreateAgrItemService {

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public AgrCreateAgrItemRspBo createAgrItem(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        AgrCreateAgrItemRspBo rspBo = new AgrCreateAgrItemRspBo();
        //1 校验
        this.validParam(agrCreateAgrItemReqBo);
        //2 组装入参数据
        AgrAgrDo agrAgrDo = JSONObject.parseObject(JSONObject.toJSONString(agrCreateAgrItemReqBo), AgrAgrDo.class);
        // 如果协议明细ID存在，则先删除后新增
        this.deleteAgrItem(agrCreateAgrItemReqBo);
        //3 调用协议明细新增法
        this.agrAgrModel.saveAgrItem(agrAgrDo);
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        return rspBo;
    }
    /**
     * 删除明细
     */
    private void deleteAgrItem( AgrCreateAgrItemReqBo agrCreateAgrItemReqBo){
        List<Long> agrItemIds = new ArrayList<>();
        agrCreateAgrItemReqBo.getAgrItem().forEach(agrItem -> {
            agrItemIds.add(agrItem.getAgrItemId());
        });
        if(!CollectionUtils.isEmpty(agrItemIds)){
            AgrAgrDo agrAgrDo1 = new AgrAgrDo();
            agrAgrDo1.setAgrId(agrCreateAgrItemReqBo.getAgrId());
            List<AgrItem> agrItems = new ArrayList<>();
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrId(agrCreateAgrItemReqBo.getAgrId());
            agrItem.setAgrItemIds(agrItemIds);
            agrItems.add(agrItem);
            agrAgrDo1.setAgrItem(agrItems);
            this.agrAgrModel.deleteAgrItemByBatch(agrAgrDo1);
        }
    }
    /**
     * 校验重复
     */
    private  void validParam(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo){
        if(agrCreateAgrItemReqBo.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "协议ID不能为空");
        }
        if(CollectionUtils.isEmpty(agrCreateAgrItemReqBo.getAgrItem())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "协议明细不能为空");
        }
    }
}
