package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrItemReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrItemRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @title: AgrDeleteAgrItemServiceImpl
 * @describe： 协议明细删除服务实现
 * @created: 2022/8/30 15:44
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrDeleteAgrItemServiceImpl implements AgrDeleteAgrItemService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrDeleteAgrItemRspBO deleteAgrItem(AgrDeleteAgrItemReqBO agrDeleteAgrItemReqBO) {
        //1.入参校验
        this.val(agrDeleteAgrItemReqBO);
        //2.组装删除服务入参
        AgrAgrDo agrAgrDo = assemblyDeleteInformation(agrDeleteAgrItemReqBO);
        //3.调用删除协议明细方法
        this.iAgrAgrModel.deleteAgrItemByBatch(agrAgrDo);

        return AgrRu.success(AgrDeleteAgrItemRspBO.class);
    }

    /**
     * 组装删除信息
     * @return AgrAgrDo
     */
    private AgrAgrDo assemblyDeleteInformation(AgrDeleteAgrItemReqBO agrDeleteAgrItemReqBO){
        AgrAgrDo agrAgrDo = JSONObject.parseObject(JSONObject.toJSONString(agrDeleteAgrItemReqBO), AgrAgrDo.class);
        List<AgrItem> agrItems = new ArrayList<>();
        AgrItem agrItem = new AgrItem();
        if (agrDeleteAgrItemReqBO.getAgrItemId() != null){
            agrItem.setAgrItemId(agrDeleteAgrItemReqBO.getAgrItemId());
        }
        if (!CollectionUtils.isEmpty(agrDeleteAgrItemReqBO.getAgrItemIds())){
            agrItem.setAgrItemIds(agrDeleteAgrItemReqBO.getAgrItemIds());
        }
        agrItems.add(agrItem);
        agrAgrDo.setAgrItem(agrItems);
        return agrAgrDo;
    }

    /**
     * 入参校验方法
     * @param agrDeleteAgrItemReqBO
     */
    private void val(AgrDeleteAgrItemReqBO agrDeleteAgrItemReqBO) {
        if (agrDeleteAgrItemReqBO == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[agrDeleteAgrItemReqBO]不能为空");
        }
        if (agrDeleteAgrItemReqBO.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]不能为空");
        }
    }
}
