package com.tydic.dyc.agr.service.agr;


import cn.hutool.core.convert.Convert;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hcl
 * @date 2022年8月30日
 */
@HTServiceImpl
public class AgrUpdateAgrItemServiceImpl implements AgrUpdateAgrItemService {

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrUpdateAgrItemRspBO updateAgrItem(AgrUpdateAgrItemReqBO reqBO) {
        //1 组装入参信息
        AgrAgrDo agrAgrDo = setModificationInformation(reqBO);
        //2 调用协议明细修改方法
        this.iAgrAgrModel.updateAgrItem(agrAgrDo);

        return AgrRu.success(AgrUpdateAgrItemRspBO.class);
    }

    /**
     * 设置修改协议明细信息
     * @param reqBO
     */
    private AgrAgrDo setModificationInformation(AgrUpdateAgrItemReqBO reqBO) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(Convert.toLong(reqBO.getAgrId()));
        List<AgrItem> agrItems = new ArrayList<>();
        AgrItem agrItem = AgrRu.js(reqBO,AgrItem.class);
        agrItems.add(agrItem);
        agrAgrDo.setAgrItem(agrItems);
        return agrAgrDo;
    }
}
