package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemSpecifyFieldReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemSpecifyFieldRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrUpdateAgrItemSpecifyFieldServiceImpl
 * 说明:TODO
 * 时间:2023/4/23 15:57
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrUpdateAgrItemSpecifyFieldServiceImpl implements AgrUpdateAgrItemSpecifyFieldService {
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Override
    public AgrUpdateAgrItemSpecifyFieldRspBO updateAgrItemSpecifyField(AgrUpdateAgrItemSpecifyFieldReqBO agrUpdateAgrItemSpecifyFieldReqBO) {
        if(agrUpdateAgrItemSpecifyFieldReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议ID不能为空");
        }
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrUpdateAgrItemSpecifyFieldReqBO.getAgrId());
        agrAgrDo.setUpdateRange(agrUpdateAgrItemSpecifyFieldReqBO.getUpdateRange());
        List<AgrItem> agrItem = new ArrayList<>();
        AgrItem bo = AgrRu.js(agrUpdateAgrItemSpecifyFieldReqBO,AgrItem.class);
        agrItem.add(bo);
        agrAgrDo.setAgrItem(agrItem);
        this.agrAgrModel.updateAgrItemSpecifyField(agrAgrDo);
        return AgrRu.success(AgrUpdateAgrItemSpecifyFieldRspBO.class);
    }
}
