package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrStatusChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrStatusChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrAgrStatusChngAuditCallBackServiceImpl
 * 说明:TODO
 * 时间:2022/9/20 12:54
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrStatusChngAuditCallBackServiceImpl implements AgrAgrStatusChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrAgrStatusChngAuditCallBackRspBO dealStatusChngAuditCallBack(AgrAgrStatusChngAuditCallBackReqBO reqBO) {
        // 1 调用变更申请状态变更
        this.invokeAgrChngApplyMain(reqBO);
        // 2 调用协议状态变更
        this.invokeUpdateAgrMain(reqBO);
        return AgrRu.success(AgrAgrStatusChngAuditCallBackRspBO.class);
    }
    /**
     * 调用协议状态变更
     */
    private void invokeUpdateAgrMain(AgrAgrStatusChngAuditCallBackReqBO reqBO){
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(reqBO.getAgrId());
        // 启用变更
        if(reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.START)){
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        }
        // 暂停变更
        if(reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)){
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.SUSPEND);
        }
        // 终止变更
        if(reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.TERMINATION)){
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.TERMINATION);
        }
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }

    /**
     * 调用变更申请状态变更
     */
    private void invokeAgrChngApplyMain(AgrAgrStatusChngAuditCallBackReqBO reqBO){
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}
