package com.tydic.dyc.agr.service.domainservice;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.agr.model.common.AgrCommonDo;
import com.tydic.dyc.agr.model.common.IAgrCommonModel;
import com.tydic.dyc.agr.model.common.qrybo.AgrChngMsgQryBo;
import com.tydic.dyc.agr.model.common.sub.AgrAgrChngMsg;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrChngMsgOperateReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrChngMsgOperateRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrAgrChngMsgOperateServiceImpl
 * 说明:TODO
 * 时间:2023/2/7 16:33
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrChngMsgOperateServiceImpl implements AgrAgrChngMsgOperateService {
    @Autowired
    private IAgrCommonModel iAgrCommonModel;
    /**
     * 操作类型 1 新增
     */
    private final  Integer operType_add = 1;
    /**
     * 操作类型 2 删除
     */
    private final  Integer operType_delete = 2;
    @Override
    public AgrAgrChngMsgOperateRspBO dealagrChngMsg(AgrAgrChngMsgOperateReqBO agrAgrChngMsgOperateReqBO) {
        if(operType_add.equals(agrAgrChngMsgOperateReqBO.getOperType())){
            AgrCommonDo agrCommonDo = new AgrCommonDo();
            List<AgrAgrChngMsg> agrAgrChngMsgs = new ArrayList<>();
            AgrAgrChngMsg agrAgrChngMsg = new AgrAgrChngMsg();
            agrAgrChngMsg.setMsgId(Sequence.getInstance().nextId());
            agrAgrChngMsg.setObjId(agrAgrChngMsgOperateReqBO.getObjId());
            agrAgrChngMsg.setObjType(agrAgrChngMsgOperateReqBO.getObjType());
            agrAgrChngMsg.setMsgType(agrAgrChngMsgOperateReqBO.getMsgType());
            agrAgrChngMsg.setMsgStatus(AgrCommConstant.agrChngMsgStatus.EFFECTIVE);
            agrAgrChngMsg.setCreateTime(new Date());
            agrAgrChngMsgs.add(agrAgrChngMsg);
            agrCommonDo.setAgrAgrChngMsg(agrAgrChngMsgs);
            iAgrCommonModel.savaAgrChngMsg(agrCommonDo);
        }else if(operType_delete.equals(agrAgrChngMsgOperateReqBO.getOperType())){
            AgrChngMsgQryBo agrChngMsgQryBo = new AgrChngMsgQryBo();
            agrChngMsgQryBo.setObjId(agrAgrChngMsgOperateReqBO.getObjId());
            agrChngMsgQryBo.setObjType(agrAgrChngMsgOperateReqBO.getObjType());
            agrChngMsgQryBo.setMsgType(agrAgrChngMsgOperateReqBO.getMsgType());
            agrChngMsgQryBo.setOrderBy("create_time desc");
            AgrCommonDo agrCommonDo = iAgrCommonModel.getAgrChngMsgList(agrChngMsgQryBo);
            if(!CollectionUtils.isEmpty(agrCommonDo.getAgrAgrChngMsg())){
                AgrAgrChngMsg msg = agrCommonDo.getAgrAgrChngMsg().get(0);
                // 更新原来冻结记录为失效
                AgrCommonDo agrCommonDo1 = new AgrCommonDo();
                List<AgrAgrChngMsg> agrAgrChngMsgs = new ArrayList<>();
                AgrAgrChngMsg agrAgrChngMsg = new AgrAgrChngMsg();
                agrAgrChngMsg.setMsgId(msg.getMsgId());
                agrAgrChngMsg.setMsgStatus(AgrCommConstant.agrChngMsgStatus.NO_EFFECTIVE);
                agrAgrChngMsgs.add(agrAgrChngMsg);
                agrCommonDo1.setAgrAgrChngMsg(agrAgrChngMsgs);
                iAgrCommonModel.updateAgrChngMsg(agrCommonDo1);

                // 新增一条解冻记录
                AgrCommonDo agrCommonDo2 = new AgrCommonDo();
                List<AgrAgrChngMsg> agrAgrChngMsgs2 = new ArrayList<>();
                AgrAgrChngMsg agrAgrChngMsg2 = new AgrAgrChngMsg();
                agrAgrChngMsg2.setMsgId(Sequence.getInstance().nextId());
                agrAgrChngMsg2.setObjId(agrAgrChngMsgOperateReqBO.getObjId());
                agrAgrChngMsg2.setObjType(agrAgrChngMsgOperateReqBO.getObjType());
                if(agrAgrChngMsgOperateReqBO.getMsgType().equals(AgrCommConstant.agrChngMsgType.FROZEN)){
                    agrAgrChngMsg2.setMsgType(AgrCommConstant.agrChngMsgType.UN_FROZEN);
                }else {
                    // todo
                }
                agrAgrChngMsg2.setMsgStatus(AgrCommConstant.agrChngMsgStatus.EFFECTIVE);
                agrAgrChngMsg2.setCreateTime(new Date());
                agrAgrChngMsg2.setRelMsgId(msg.getMsgId());
                agrAgrChngMsgs2.add(agrAgrChngMsg2);
                agrCommonDo2.setAgrAgrChngMsg(agrAgrChngMsgs2);
                iAgrCommonModel.savaAgrChngMsg(agrCommonDo2);
            }


        }
        AgrAgrChngMsgOperateRspBO rspBO = new AgrAgrChngMsgOperateRspBO();
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
