package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @title: AgrGetAgrItemListServiceImpl
 * @describe： 协议明细列表查询服务实现
 * @created: 2022/8/30 14:12
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrItemListServiceImpl implements AgrGetAgrItemListService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrGetAgrItemListRspBO getAgrItemList(AgrGetAgrItemListReqBO reqBO) {
        //1 组装入参
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBO, AgrItemListQryReqPageBo.class);
        //2 调用协议明细列表查询方法
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        //3 组装出参
        AgrGetAgrItemListRspBO rspBO = JSONObject.parseObject(JSONObject.toJSONString(agrItemListQryRspPageBo), AgrGetAgrItemListRspBO.class);
        //4 是否成品油转义
        this.translation(rspBO);

        return rspBO;
    }

    /**
     * 是否成品油转义
     * @param rspBO 入参
     */
    private void translation(AgrGetAgrItemListRspBO rspBO) {
        if (rspBO != null) {
            List<AgrItemDetailBo> rows = rspBO.getRows();
            if (!CollectionUtils.isEmpty(rows)) {
                rows.forEach(x -> {
                            Integer whetherOil = x.getWhetherOil();
                            if (whetherOil != null) {
                                x.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode(whetherOil));
                            }
                        }
                );
            }
        }
    }
}
