package com.tydic.dyc.agr.service.agrchange;

import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCheckAgrChngItemSaveReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCheckAgrChngItemSaveRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrCheckAgrChngItemSaveServiceImpl
 * 说明:TODO
 * 时间:2023/4/23 19:55
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrCheckAgrChngItemSaveServiceImpl implements AgrCheckAgrChngItemSaveService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Override
    public AgrCheckAgrChngItemSaveRspBO checkAgrChngItemSave(AgrCheckAgrChngItemSaveReqBO agrCheckAgrChngItemSaveReqBO) {
        if(agrCheckAgrChngItemSaveReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议ID不能为空");
        }
        if(agrCheckAgrChngItemSaveReqBO.getChngApplyId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "变更申请ID不能为空");
        }
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(agrCheckAgrChngItemSaveReqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(agrCheckAgrChngItemSaveReqBO.getChngApplyId());
        this.iAgrChngApplyModel.checkAgrChngItemSave(agrChngApplyDo);
        return AgrRu.success(AgrCheckAgrChngItemSaveRspBO.class);
    }
}
