package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @title: AgrCreateAgrItemChngServiceImpl
 * @describe： 协议明细变更新增服务
 * @created: 2022/9/14 16:34
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrCreateAgrItemChngServiceImpl implements AgrCreateAgrItemChngService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrCreateAgrItemChngRspBO createAgrItemChng(AgrCreateAgrItemChngReqBO agrCreateAgrItemChngReqBO) {
        //1 入参校验
        this.validation(agrCreateAgrItemChngReqBO);
        //2 组装协议明细新增入参
        AgrChngApplyDo agrChngApplyDo = JSONObject.parseObject(JSONObject.toJSONString(agrCreateAgrItemChngReqBO),AgrChngApplyDo.class);
        this.deleteAgrChngItem(agrCreateAgrItemChngReqBO);
        log.debug("组装协议明细变更新增入参[agrChngApplyDo]:{}",agrChngApplyDo);

        if(!CollectionUtils.isEmpty(agrChngApplyDo.getAgrItemChng())){
            // 查询交易模式
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo() ;
            agrAgrQryBo.setAgrId(agrCreateAgrItemChngReqBO.getAgrId());
            AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
            List<AgrItemChng> move  = new ArrayList<>();
            agrChngApplyDo.getAgrItemChng().forEach(agrItemChng -> {
                if(AgrCommConstant.AgreementSkuChangeType.ADD.equals(agrItemChng.getItemChngType())){
                    if(agrItemChng.getSalePrice()!=null && agrItemChng.getBuyPrice()==null){
                        agrItemChng.setBuyPrice(agrItemChng.getSalePrice());
                        agrItemChng.setBuyPriceSum(agrItemChng.getSalePriceSum());
                    }
                }
                if(AgrCommConstant.AgreementSkuChangeType.UPDATE.equals(agrItemChng.getItemChngType())){
                    if(AgrCommConstant.TradeMode.PURCHASE_AND_SALE.equals(agrAgrDo.getTradeMode())){
                        if(agrItemChng.getBuyPrice()==null && agrItemChng.getMarkupRate()==null && agrItemChng.getSalePrice()==null && agrItemChng.getBuyNumber()==null){
                            move.add(agrItemChng);
                        }
                    }else if(AgrCommConstant.TradeMode.MATCH_UP.equals(agrAgrDo.getTradeMode())){
                        if(agrItemChng.getSalePrice()==null && agrItemChng.getBuyNumber()==null){
                            move.add(agrItemChng);
                        }else {
                            agrItemChng.setBuyPrice(agrItemChng.getSalePrice());
                            agrItemChng.setBuyPriceSum(agrItemChng.getSalePriceSum());
                        }
                    }

                }
            });
            if(move.size()>0){
                agrChngApplyDo.getAgrItemChng().removeAll(move);
            }
        }
        //3 调用协议明细变更新增方法
        if(!CollectionUtils.isEmpty(agrChngApplyDo.getAgrItemChng())){
            this.iAgrChngApplyModel.saveAgrItemChng(agrChngApplyDo);
        }
        return  AgrRu.success(AgrCreateAgrItemChngRspBO.class);
    }
    /**
     * 删除明细
     */
    private void deleteAgrChngItem( AgrCreateAgrItemChngReqBO agrCreateAgrItemChngReqBO){
        List<Long> agrItemChngIds = new ArrayList<>();
        agrCreateAgrItemChngReqBO.getAgrItemChng().forEach(agrItemChng-> {
            agrItemChngIds.add(agrItemChng.getAgrItemChngId());
        });
        if(!CollectionUtils.isEmpty(agrItemChngIds)){
            AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
            agrChngApplyDo.setAgrId(agrCreateAgrItemChngReqBO.getAgrId());
            agrChngApplyDo.setChngApplyId(agrCreateAgrItemChngReqBO.getChngApplyId());
            List<AgrItemChng> agrItemChngs = new ArrayList<>();
            AgrItemChng agrItemChng = new AgrItemChng();
            agrItemChng.setAgrItemChngIds(agrItemChngIds);
            agrItemChngs.add(agrItemChng);
            agrChngApplyDo.setAgrItemChng(agrItemChngs);
            this.iAgrChngApplyModel.deleteAgrItemChng(agrChngApplyDo);
        }
    }
    /**
     * 入参校验
     * @param agrCreateAgrItemChngReqBO
     */
    private void validation(AgrCreateAgrItemChngReqBO agrCreateAgrItemChngReqBO) {
        if (ObjectUtil.isEmpty(agrCreateAgrItemChngReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateAgrItemChngReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateAgrItemChngReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (CollectionUtils.isEmpty(agrCreateAgrItemChngReqBO.getAgrItemChng())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细变更]不能为空");
        }
        if (!CollectionUtils.isEmpty(agrCreateAgrItemChngReqBO.getAgrItemChng())) {
            agrCreateAgrItemChngReqBO.getAgrItemChng().forEach(agrItemChng -> {
                if (ObjectUtil.isEmpty(agrItemChng.getItemChngType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[明细变更类型]不能为空");
                }
                if(agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.ADD)){
                    agrItemChng.setAgrItemId(IdUtil.nextId());
                }
                if (!CollectionUtils.isEmpty(agrItemChng.getAgrItemLadderPriceChng())) {
                    agrItemChng.getAgrItemLadderPriceChng().forEach(agrItemLadderPriceChngBo -> {
                        if (ObjectUtil.isEmpty(agrItemLadderPriceChngBo.getStart())) {
                            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[价格起量]不能为空");
                        }
                        if (ObjectUtil.isEmpty(agrItemLadderPriceChngBo.getStop())) {
                            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[价格止量]不能为空");
                        }
                        if (ObjectUtil.isEmpty(agrItemLadderPriceChngBo.getPrice())) {
                            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[价格]不能为空");
                        }
                    });
                }
                if (!CollectionUtils.isEmpty(agrItemChng.getAgrItemExtChng())) {
                    agrItemChng.getAgrItemExtChng().forEach(agrItemExtChngBo -> {
                        if (ObjectUtil.isEmpty(agrItemExtChngBo.getFieldCode())) {
                            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[字段编码]不能为空");
                        }
                        if (ObjectUtil.isEmpty(agrItemExtChngBo.getFieldName())) {
                            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[字段名称]不能为空");
                        }
                    });
                }
            });
        }

    }


}
