package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListRspBO;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngApply;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgMainChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgMainChngRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @title: AgrCreateArgMainChngServiceImpl
 * @describe： 协议主体变更申请新增服务
 * @created: 2022/9/9 15:42
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrCreateArgMainChngServiceImpl implements AgrCreateArgMainChngService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrCreateArgMainChngRspBO createAgrMainChng(AgrCreateArgMainChngReqBO agrCreateArgMainChngReqBO) {

        //1 入参校验
        this.validation(agrCreateArgMainChngReqBO);

        AgrCreateArgMainChngRspBO agrCreateArgMainChngRspBO = AgrRu.success(AgrCreateArgMainChngRspBO.class);
        this.getDeleteChng(agrCreateArgMainChngRspBO,agrCreateArgMainChngReqBO);

        //2 组装协议主体变更申请新增入参
        AgrChngApplyDo agrChngApplyDo = JSONObject.parseObject(JSONObject.toJSONString(agrCreateArgMainChngReqBO),AgrChngApplyDo.class);
        //3 调用协议主体变更申请新增方法
        this.iAgrChngApplyModel.createAgrMainChng(agrChngApplyDo);
        //4 新增协议明细变更信息
        if(!CollectionUtils.isEmpty(agrCreateArgMainChngReqBO.getAgrItemChng())){
            AgrChngApplyDo agrChngApplyDo1 = JSONObject.parseObject(JSON.toJSONString(agrCreateArgMainChngReqBO), AgrChngApplyDo.class);
            this.iAgrChngApplyModel.saveAgrItemChng(agrChngApplyDo1);
        }
        return  agrCreateArgMainChngRspBO;
    }
    /**
     * 查询需要删除变更申请
     */
    private void getDeleteChng(AgrCreateArgMainChngRspBO agrCreateArgMainChngRspBO , AgrCreateArgMainChngReqBO agrCreateArgMainChngReqBO){
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(agrCreateArgMainChngReqBO.getAgrId());
        AgrAgrChngApplyListRspBO rspBO = this.iAgrChngApplyModel.getAgrChngApplyList(agrAgrChngApplyQryBo);
        if(!CollectionUtils.isEmpty(rspBO.getAgrChngApply())){
            for (AgrChngApply agrChngApply:rspBO.getAgrChngApply()) {
                if(!AgrCommConstant.ChangeApplyStatus.IN_AUDIT.equals(Integer.parseInt(agrChngApply.getChngApplyStatus()))
                        && !AgrCommConstant.ChangeApplyStatus.TO_CONFIRM.equals(Integer.parseInt(agrChngApply.getChngApplyStatus()))){
                    agrCreateArgMainChngRspBO.setDeleteChngApplyId(agrChngApply.getChngApplyId());
                    log.info("deleteChngApplyId" +agrCreateArgMainChngRspBO.getDeleteChngApplyId());
                    break;
                }
            }

        }
    }
    /**
     * 入参校验
     * @param agrCreateArgMainChngReqBO
     */
    private void validation(AgrCreateArgMainChngReqBO agrCreateArgMainChngReqBO) {
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getChngApplyNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getChngType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议变更类型]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrVersion())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议版本]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrMainChng())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体变更]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrMainChng().getAgrVersion())) {
            if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrMainChng().getAgrCode())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体编号]不能为空");
            }
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体版本]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrMainChng().getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体ID]不能为空");
        }
        if (!CollectionUtils.isEmpty(agrCreateArgMainChngReqBO.getAgrAppScopeChng())) {
            agrCreateArgMainChngReqBO.getAgrAppScopeChng().forEach(agrAppScopeChng -> {
                if (ObjectUtil.isEmpty(agrAppScopeChng.getScopeCode())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[应用范围编码]不能为空");
                }
                if (ObjectUtil.isEmpty(agrAppScopeChng.getScopeName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[应用范围名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrAppScopeChng.getScopeType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[应用范围类型]不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(agrCreateArgMainChngReqBO.getAgrPayConfigChng())) {
            agrCreateArgMainChngReqBO.getAgrPayConfigChng().forEach(agrPayConfigChng -> {
                if (ObjectUtil.isEmpty(agrPayConfigChng.getPayObj())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[支付方]不能为空");
                }
                if (ObjectUtil.isEmpty(agrPayConfigChng.getPayType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[支付方式]不能为空");
                }
            });
        }
        if (ObjectUtil.isNotEmpty(agrCreateArgMainChngReqBO.getAgrAdjustCfgChng())) {
            if (ObjectUtil.isEmpty(agrCreateArgMainChngReqBO.getAgrAdjustCfgChng().getAdjustPrice())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[调价机制]不能为空");
            }
        }
        if (!CollectionUtils.isEmpty(agrCreateArgMainChngReqBO.getAgrCataScopeChng())) {
            agrCreateArgMainChngReqBO.getAgrCataScopeChng().forEach(agrCataScopeChng -> {
                if (ObjectUtil.isEmpty(agrCataScopeChng.getCatalogCode())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[类目编号]不能为空");
                }
                if (ObjectUtil.isEmpty(agrCataScopeChng.getCatalogName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[类目名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrCataScopeChng.getCatalogLevel())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[类目层级]不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(agrCreateArgMainChngReqBO.getAgrMainExtChng())) {
            agrCreateArgMainChngReqBO.getAgrMainExtChng().forEach(agrMainExtChng -> {
                if (ObjectUtil.isEmpty(agrMainExtChng.getFieldName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[字段名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrMainExtChng.getFieldCode())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[字段编码]不能为空");
                }
                if (ObjectUtil.isEmpty(agrMainExtChng.getFieldValue())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[字段值]不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(agrCreateArgMainChngReqBO.getAgrChngAccessory())) {
            agrCreateArgMainChngReqBO.getAgrChngAccessory().forEach(agrChngAccessory -> {
//                if (ObjectUtil.isEmpty(agrChngAccessory.getAttachmentType())) {
//                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件类型]不能为空");
//                }
//                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryName())) {
//                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件名称]不能为空");
//                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryUrl())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件url]不能为空");
                }
            });
        }
    }
}
