package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrMainChngDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrMainChngDetailRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrMainChngDetailBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrPayConfigChngBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @title: AgrGetAgrMainChngDetailServiceImpl
 * @describe： 协议主体变更详情查询服务
 * @created: 2022/9/13 17:14
 * @author: FKC
 */
@HTServiceImpl
@Slf4j
public class AgrGetAgrMainChngDetailServiceImpl implements AgrGetAgrMainChngDetailService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrGetAgrMainChngDetailRspBO getAgrMainChngDetail(AgrGetAgrMainChngDetailReqBO agrGetAgrMainChngDetailReqBO) {
        //1 入参校验
        this.validation(agrGetAgrMainChngDetailReqBO);
        //2 组装协议主体变更详情查询入参
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = JSONObject.parseObject(JSONObject.toJSONString(agrGetAgrMainChngDetailReqBO), AgrAgrChngApplyQryBo.class);
        log.debug("协议主体变更详情查询入参[agrChngApplyDo]:{}", agrAgrChngApplyQryBo);
        //3 协议变更申请修改
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        //4 出参类型转换
        AgrGetAgrMainChngDetailRspBO agrGetAgrMainChngDetailRspBO = JSONObject.parseObject(JSONObject.toJSONString(agrChngApplyDo), AgrGetAgrMainChngDetailRspBO.class);
        //5 字段转义
        this.agrMainTransferredMeaning(agrGetAgrMainChngDetailRspBO);

        return agrGetAgrMainChngDetailRspBO;
    }

    /**
     * 入参校验
     *
     * @param agrGetAgrMainChngDetailReqBO 入参
     */
    private void validation(AgrGetAgrMainChngDetailReqBO agrGetAgrMainChngDetailReqBO) {
        if (ObjectUtil.isEmpty(agrGetAgrMainChngDetailReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrGetAgrMainChngDetailReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrGetAgrMainChngDetailReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    /**
     * 协议主体所需字段转义
     *
     * @return
     */
    private void agrMainTransferredMeaning(AgrGetAgrMainChngDetailRspBO rspBO) {
        //协议主体字段转义
        AgrMainChngDetailBo agrMainChngDetailBo = rspBO.getAgrMainChng();
        if (ObjectUtil.isNotEmpty(agrMainChngDetailBo)){
            //协议模式转义  协议模式 1：平台协议 2：单位协议 默认1
            if (agrMainChngDetailBo.getAgrMode() != null) {
                agrMainChngDetailBo.setAgrModeStr(AgrCommConstant.AgreementModeEnum.getValueByCode(agrMainChngDetailBo.getAgrMode()));
            }
            //协议分类转义 协议分类 0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
            if (agrMainChngDetailBo.getAgrType() != null) {
                agrMainChngDetailBo.setAgrTypeStr(AgrCommConstant.AgrTypeEnum.getValueByCode(agrMainChngDetailBo.getAgrType()));
            }
            //协议价格类型转义 价格类型 1：执行价 2：协议价 默认1
            if (agrMainChngDetailBo.getAgrPriceType() != null) {
                agrMainChngDetailBo.setAgrPriceTypeStr(AgrCommConstant.AgrPriceTypeEnum.getValueByCode(agrMainChngDetailBo.getAgrPriceType()));
            }
            //协议来源转义 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
            if (agrMainChngDetailBo.getAgrSrc() != null) {
                agrMainChngDetailBo.setAgrSrcStr(AgrCommConstant.AgrSrcEnum.getValueByCode(agrMainChngDetailBo.getAgrSrc()));
            }
            //交易模式转义 交易模式：1：购销模式 2：搓合模式
            if (agrMainChngDetailBo.getTradeMode() != null) {
                agrMainChngDetailBo.setTradeModeStr(AgrCommConstant.TradeModeEnum.getValueByCode(agrMainChngDetailBo.getTradeMode()));
            }
            //是否配送转义 是否配送 0:否,1是 默认值：是
            if (agrMainChngDetailBo.getWhetherDispatch() != null) {
                agrMainChngDetailBo.setWhetherDispatchStr(AgrCommConstant.WhetherDispatchEnum.getValueByCode(agrMainChngDetailBo.getWhetherDispatch()));
            }
            //是否分配转义 是否配送 0:否,1是 默认值：是
            if (agrMainChngDetailBo.getWhetherAssign() != null) {
                agrMainChngDetailBo.setWhetherAssignStr(AgrCommConstant.WhetherAssignEnum.getValueByCode(agrMainChngDetailBo.getWhetherAssign()));
            }
            //采购类别：1物资类、2施工类、3服务类
            if (agrMainChngDetailBo.getAgreementVariety() != null) {
                agrMainChngDetailBo.setAgreementVarietyStr(AgrCommConstant.AgreementVarietyEnum.getValueByCode(agrMainChngDetailBo.getAgreementVariety()));
            }
            //应用范围类型转义 选项值：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无
            if (agrMainChngDetailBo.getScopeType() != null) {
                agrMainChngDetailBo.setScopeTypeStr(AgrCommConstant.ScopeTypeEnum.getValueByCode(agrMainChngDetailBo.getScopeType()));
            }
            //调价机制转义 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
            if (agrMainChngDetailBo.getAdjustPrice() != null) {
                agrMainChngDetailBo.setAdjustPriceStr(AgrCommConstant.AdjustPriceEnum.getValueByCode(agrMainChngDetailBo.getAdjustPrice()));
            }
            //铺货方式转义 铺货方式：1：运营商自主铺货 2：供应商铺货 3:采购单位铺货
            if (agrMainChngDetailBo.getVendorMode() != null) {
                agrMainChngDetailBo.setVendorModeStr(AgrCommConstant.VendorModeEnum.getValueByCode(agrMainChngDetailBo.getVendorMode()));
            }
            //是否有明细标识转义  1：是，0：否
            if(agrMainChngDetailBo.getWhetherHaveItem() != null){
                agrMainChngDetailBo.setWhetherHaveItemStr(AgrCommConstant.WhetherHaveItemEnum.getValueByCode(agrMainChngDetailBo.getWhetherHaveItem()));
            }
            //是否商城铺货标识转义 是否商城铺货标识 1：是，0：否
            if(agrMainChngDetailBo.getWhetherStorePlan() != null){
                agrMainChngDetailBo.setWhetherStorePlanStr(AgrCommConstant.WhetherStorePlanEnum.getValueByCode(agrMainChngDetailBo.getWhetherStorePlan()));
            }
            //铺货方式转义
            if(agrMainChngDetailBo.getVendorMode() != null){
                agrMainChngDetailBo.setVendorModeStr(AgrCommConstant.VendorModeEnum.getValueByCode(agrMainChngDetailBo.getVendorMode()));
            }
        }
        rspBO.setAgrMainChng(agrMainChngDetailBo);
        //协议支付配置变更字段转义
        List<AgrPayConfigChngBo> agrPayConfigChngBos = rspBO.getAgrPayConfigChng();
        if (!CollectionUtils.isEmpty(agrPayConfigChngBos)){
            agrPayConfigChngBos.forEach(agrPayConfigChngBo -> {
                //支付方试: 0 预付款 1 分阶段 2 账期
                if (agrPayConfigChngBo.getPayType() != null) {
                    agrPayConfigChngBo.setPayTypeStr(AgrCommConstant.PayTypeEnum.getValueByCode(agrPayConfigChngBo.getPayType()));
                }
                agrPayConfigChngBo.setAssignStr(AgrCommConstant.AssignEnum.getValueByCode(agrPayConfigChngBo.getAssign()));
                //判断是否为指定日期
                if(agrPayConfigChngBo.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())){
                    //设置业务节点转义
                    agrPayConfigChngBo.setBusiNodeStr(AgrCommConstant.IsAssign.getValueByCode(agrPayConfigChngBo.getBusiNode()));
                }else if(agrPayConfigChngBo.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())){
                    //设置业务节点转义
                    agrPayConfigChngBo.setBusiNodeStr(AgrCommConstant.NoAssign.getValueByCode(agrPayConfigChngBo.getBusiNode()));
                }
            });
        }

    }
}
