package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.service.agrchange.bo.AgrUpdateArgMainChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrUpdateArgMainChngRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @title: AgrUpdateArgMainChngServiceImpl
 * @describe： 协议主体变更申请修改服务
 * @created: 2022/9/9 15:30
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrUpdateArgMainChngServiceImpl implements AgrUpdateArgMainChngService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrUpdateArgMainChngRspBO updateAgrMainChng(AgrUpdateArgMainChngReqBO agrUpdateArgMainChngReqBO) {
        //入参校验
        this.validation(agrUpdateArgMainChngReqBO);
        //组装协议主体变更申请修改入参
        AgrChngApplyDo agrChngApplyDo = JSONObject.parseObject(JSONObject.toJSONString(agrUpdateArgMainChngReqBO),AgrChngApplyDo.class);
        //协议主体变更申请修改
        this.iAgrChngApplyModel.updateAgrMainChng(agrChngApplyDo);
        return  AgrRu.success(AgrUpdateArgMainChngRspBO.class);
    }

    /**
     * 入参校验
     * @param agrUpdateArgMainChngReqBO
     */
    private void validation(AgrUpdateArgMainChngReqBO agrUpdateArgMainChngReqBO) {
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getChngApplyNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getChngType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议变更类型]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrVersion())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议版本]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrMainChng())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体变更]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrMainChng().getAgrCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrMainChng().getAgrVersion())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体版本]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrMainChng().getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议主体ID]不能为空");
        }
        if (!CollectionUtils.isEmpty(agrUpdateArgMainChngReqBO.getAgrAppScopeChng())) {
            agrUpdateArgMainChngReqBO.getAgrAppScopeChng().forEach(agrAppScopeChng -> {
                if (ObjectUtil.isEmpty(agrAppScopeChng.getScopeCode())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[应用范围编码]不能为空");
                }
                if (ObjectUtil.isEmpty(agrAppScopeChng.getScopeName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[应用范围名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrAppScopeChng.getScopeType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[应用范围类型]不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(agrUpdateArgMainChngReqBO.getAgrPayConfigChng())) {
            agrUpdateArgMainChngReqBO.getAgrPayConfigChng().forEach(agrPayConfigChng -> {
                if (ObjectUtil.isEmpty(agrPayConfigChng.getPayObj())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[支付方]不能为空");
                }
                if (ObjectUtil.isEmpty(agrPayConfigChng.getPayType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[支付方式]不能为空");
                }
            });
        }
        if (ObjectUtil.isNotEmpty(agrUpdateArgMainChngReqBO.getAgrAdjustCfgChng())) {
            if (ObjectUtil.isEmpty(agrUpdateArgMainChngReqBO.getAgrAdjustCfgChng().getAdjustPrice())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[调价机制]不能为空");
            }
        }
        if (!CollectionUtils.isEmpty(agrUpdateArgMainChngReqBO.getAgrCataScopeChng())) {
            agrUpdateArgMainChngReqBO.getAgrCataScopeChng().forEach(agrCataScopeChng -> {
                if (ObjectUtil.isEmpty(agrCataScopeChng.getCatalogName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[类目名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrCataScopeChng.getCatalogLevel())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[类目层级]不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(agrUpdateArgMainChngReqBO.getAgrChngAccessory())) {
            agrUpdateArgMainChngReqBO.getAgrChngAccessory().forEach(agrChngAccessory -> {
                if (ObjectUtil.isEmpty(agrChngAccessory.getAttachmentType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件类型]不能为空");
                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryUrl())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件url]不能为空");
                }
            });
        }
    }
}
