package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAdjustChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAdjustChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrAgrAdjustChngAuditCallBackServiceImpl
 * 说明:TODO
 * 时间:2022/9/23 13:02
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrAdjustChngAuditCallBackServiceImpl implements AgrAgrAdjustChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrAgrAdjustChngAuditCallBackRspBO dealAdjustChngAuditCallBack(AgrAgrAdjustChngAuditCallBackReqBO reqBO) {
        // 1 调用变更申请状态变更
        this.invokeUpdateAgrChngApplyMain(reqBO);
        // 2 修改明细相关信息
        this.syncAgrItem(reqBO);
        return AgrRu.success(AgrAgrAdjustChngAuditCallBackRspBO.class);
    }
    /**
     * 协议明细修改
     */
    private void syncAgrItem(AgrAgrAdjustChngAuditCallBackReqBO reqBO){
        // 1 查询协议明细变更列表
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(reqBO.getAgrId());
        reqPageBo.setChngApplyId(reqBO.getChngApplyId());
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        reqPageBo.setItemChngType(AgrCommConstant.AgreementSkuChangeType.UPDATE);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if(rspPageBo.getTotal()>0){
            int total = rspPageBo.getTotal();
            for (int i=1;i<=total;i++){
                reqPageBo.setPageNo(i);
                reqPageBo.setPageSize(1000);
                AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                List<AgrItemChng> updateAgrItemChngs = new ArrayList<>();
                rspPageBo1.getRows().forEach(agrItemChng -> {
                    if(agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.UPDATE)){
                        updateAgrItemChngs.add(agrItemChng);
                    }
                });
                // 新增协议明细修改
                this.updateAgrItem(updateAgrItemChngs,reqBO.getAgrId());
            }
        }
    }
    /**
     * 新增协议明细
     */
    private void updateAgrItem(List<AgrItemChng> agrItemChngs,Long agrId){
        if(!CollectionUtils.isEmpty(agrItemChngs)){
            agrItemChngs.forEach(agrItemChng -> {
                List<AgrItem> agrItems = new ArrayList<>();
                AgrItem agrItem = new AgrItem();
                agrItem.setAgrItemId(agrItemChng.getAgrItemId());
                agrItem.setBuyPrice(agrItemChng.getBuyPrice());
                agrItem.setBuyNumber(agrItemChng.getBuyNumber());
                agrItem.setBuyPriceSum(agrItemChng.getBuyPriceSum());
                agrItem.setSalePrice(agrItemChng.getSalePrice());
                agrItem.setSalePriceSum(agrItemChng.getSalePriceSum());
                agrItem.setMarkupRate(agrItemChng.getMarkupRate());
                agrItems.add(agrItem);

                AgrAgrDo agrAgrDo = new AgrAgrDo();
                agrAgrDo.setAgrId(agrId);
                agrAgrDo.setAgrItem(agrItems);
                this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
            });
        }
    }
    /**
     * 调用变更申请状态变更
     */
    private void invokeUpdateAgrChngApplyMain(AgrAgrAdjustChngAuditCallBackReqBO reqBO){
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}
