package com.tydic.dyc.agr.service.domainservice;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrDeferChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrDeferChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrAgrDeferChngAuditCallBackServiceImpl
 * 说明:TODO
 * 时间:2022/9/20 13:06
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrDeferChngAuditCallBackServiceImpl implements AgrAgrDeferChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrAgrDeferChngAuditCallBackRspBO dealDeferChngAuditCallBack(AgrAgrDeferChngAuditCallBackReqBO reqBO) {
        // 1 调用变更申请状态变更
        this.invokeUpdateAgrChngApplyMain(reqBO);
        // 2 调用变更申请详情查询
        AgrChngApplyDo agrChngApplyDo = this.getChngApplyDetail(reqBO);
        // 3 调用协议信息修改修改协议失效时间
        this.invokeUpdateAgrMain(agrChngApplyDo);
        return AgrRu.success(AgrAgrDeferChngAuditCallBackRspBO.class);
    }
    /**
     * 调用协议信息修改
     */
    private void invokeUpdateAgrMain(AgrChngApplyDo agrChngApplyDo){
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrChngApplyDo.getAgrId());
        agrAgrDo.setExpDate(agrChngApplyDo.getPostExpDate());
        agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }

    /**
     * 调用变更申请详情查询服务
     */
    private AgrChngApplyDo getChngApplyDetail(AgrAgrDeferChngAuditCallBackReqBO reqBO){
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(reqBO.getAgrId());
        agrAgrChngApplyQryBo.setChngApplyId(reqBO.getChngApplyId());
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrChngApplyDetail(agrAgrChngApplyQryBo);
        if(agrChngApplyDo.getChngApplyId()== null){
            throw new ZTBusinessException("变更申请信息不存在" + agrChngApplyDo.getChngApplyId());
        }
        return agrChngApplyDo;

    }

    /**
     * 调用变更申请状态变更
     */
    private void invokeUpdateAgrChngApplyMain(AgrAgrDeferChngAuditCallBackReqBO reqBO){
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}
