package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agrsync.AgrSyncRecordDo;
import com.tydic.dyc.agr.model.agrsync.IAgrSyncRecordModel;
import com.tydic.dyc.agr.model.agrsync.sub.AgrItemInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrMainInfo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrSyncReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrSyncRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrItemInfoBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrMainInfoBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrAgrSyncServiceImpl
 * 说明:TODO
 * 时间:2023/1/30 11:30
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class AgrAgrSyncServiceImpl implements AgrAgrSyncService {
    @Autowired
    private IAgrSyncRecordModel iAgrSyncRecordModel;
    @Override
    public AgrAgrSyncRspBO dealAgrSync(AgrAgrSyncReqBO reqBO) {
        log.info("入参===="+JSON.toJSONString(reqBO));
        AgrAgrSyncRspBO agrAgrSyncRspBO = new AgrAgrSyncRspBO();
        agrAgrSyncRspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);

        AgrSyncRecordDo agrSyncRecordDo = new AgrSyncRecordDo() ;
        agrSyncRecordDo.setAgrId(reqBO.getAgrId());
        agrSyncRecordDo.setBatchNo(reqBO.getBatchNo());
        agrSyncRecordDo.setBatchNum(reqBO.getBatchNum());
        agrSyncRecordDo.setSyncType(reqBO.getSyncType());
        if(AgrCommConstant.AgrSyncType.AGR_MAIN.equals(reqBO.getSyncType())){
            AgrMainInfoBO agrMainInfoReq = reqBO.getAgrMainInfo();
            AgrMainInfo agrMainInfo = AgrRu.js(reqBO,AgrMainInfo.class);
            agrMainInfo.setAgrCode(agrMainInfoReq.getAgrCode());
            agrMainInfo.setAgrMainJson(JSON.toJSONString(agrMainInfoReq));
            agrSyncRecordDo.setAgrMainInfo(agrMainInfo);
        }else if(AgrCommConstant.AgrSyncType.AGR_ITEM.equals(reqBO.getSyncType())){
            List<AgrItemInfoBO> agrItemInfoBOs = reqBO.getAgrItemInfo();
            List<AgrItemInfo> agrItemInfos = new ArrayList<>();
            agrItemInfoBOs.forEach(agrItemInfoBO -> {
                AgrItemInfo agrItemInfo = new AgrItemInfo();
                agrItemInfo.setAgrId(reqBO.getAgrId());
                agrItemInfo.setAgrItemId(agrItemInfoBO.getAgrItemId());
                agrItemInfo.setBatchNo(reqBO.getBatchNo());
                agrItemInfo.setAgrItemJson(JSON.toJSONString(agrItemInfoBO));
                agrItemInfos.add(agrItemInfo);
            });
            agrSyncRecordDo.setAgrItemInfo(agrItemInfos);
        }else {
            agrAgrSyncRspBO.setRespCode(AgrRspConstant.RESP_CODE_ERROR);
            agrAgrSyncRspBO.setRespDesc("同步类型不正确");
        }
        iAgrSyncRecordModel.saveAgrSyncRecord(agrSyncRecordDo);
        return agrAgrSyncRspBO;
    }
}
