package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSubmitAgrReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSubmitAgrRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @title: AgrSubmitAgrServiceImpl
 * @describe： 协议提交服务
 * @created: 2022/8/31 16:43
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrSubmitAgrServiceImpl implements AgrSubmitAgrService{
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrSubmitAgrRspBO dealSubmitAgr(AgrSubmitAgrReqBO agrSubmitAgrReqBO) {
        //组装协议入参
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrSubmitAgrReqBO.getAgrId());
        //协议状态:待确认
        agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.TO_CONFIRM);
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
        return AgrRu.success(AgrSubmitAgrRspBO.class);
    }
}
