package com.tydic.dyc.agr.service.procinst;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.procinst.bo.AgrCandidatesBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskInfoBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrTaskDealServiceImpl
 * 说明:TODO
 * 时间:2022/9/2 15:30
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrTaskDealServiceImpl implements AgrTaskDealService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrTaskDealRspBO dealTask(AgrTaskDealReqBO reqBO) {
        AgrTaskDealRspBO rspBO = new AgrTaskDealRspBO();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            // 处理待办
            uocOrderTaskInst = this.dealToDo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            // 处理已办
            uocOrderTaskInst = this.dealDone(reqBO);
        }
        // 处理前加签
        if(StringUtils.isNotBlank(reqBO.getPreTaskId())){
            uocOrderTaskInst = this.dealPreTask(reqBO.getPreTaskId(),reqBO.getOrderId());
        }
        // 处理回退
        if(StringUtils.isNotBlank(reqBO.getReturnTaskId())){
            uocOrderTaskInst = this.dealReturnTask(reqBO.getPreTaskId(),reqBO.getOrderId());
        }
        // 处理转签
        if(reqBO.getUpdateTaskCandidate()!=null && org.springframework.util.StringUtils.hasText(reqBO.getUpdateTaskCandidate().getTaskId())){
            uocOrderTaskInst = this.dealTaskDealUpdate(reqBO.getUpdateTaskCandidate(),reqBO.getOrderId());
        }
        this.dealRsp(rspBO,uocOrderTaskInst);
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc("任务处理成功");
        return rspBO;
    }
    /**
     * 处理出参
     */
    private void dealRsp(AgrTaskDealRspBO rspBO,UocOrderTaskInst uocOrderTaskInst){
        if(uocOrderTaskInst!=null){
            String pickerConfigNo = uocOrderTaskInst.getObjType().toString();
            rspBO.setMainObjId(uocOrderTaskInst.getObjId()+"");
            if(uocOrderTaskInst.getObjType().equals(AgrCommConstant.ObjType.APPROVE)){
                AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
                agrAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
                AgrAuditOrderDo agrAuditOrderDo = iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
                pickerConfigNo=agrAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
                rspBO.setMainObjId(agrAuditOrderDo.getUocApprovalObj().get(0).getObjId());
            }
            rspBO.setPickerConfigNo(pickerConfigNo+"_"+uocOrderTaskInst.getObjType());
            rspBO.setObjId(uocOrderTaskInst.getObjId());
            rspBO.setOrderId(uocOrderTaskInst.getOrderId());
        }

    }
       /**
     * 处理回退
     */
    private UocOrderTaskInst dealReturnTask(String taskId,Long orderId){
        //1 校验任务是否是待办
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId,orderId);
        //2 删除任务信息
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setTaskInstId(taskId);
        agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        agrTaskQryBo.setOrderId(orderId);
        agrTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        this.deleteTask(agrTaskQryBo);
        return uocOrderTaskInst;
    }
    /**
     * 处理前加签
     */
    private UocOrderTaskInst dealPreTask(String taskId,Long orderId){
        //1 校验任务是否是待办
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId,orderId);
        //2 删除任务信息
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setOrderId(orderId);
        agrTaskQryBo.setTaskInstId(taskId);
        agrTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        this.deleteTask(agrTaskQryBo);
        return uocOrderTaskInst;
    }
    /**
     * 更新任务处理人
     */
    private UocOrderTaskInst dealTaskDealUpdate(AgrTaskInfoBO completeTaskBo,Long orderId){
        //1 校验任务是否是待办
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(),orderId);
        // 2 修改任务处理人
        List<UocOrderTaskDeal> agrUocOrderTaskDeal = new ArrayList<>();
        UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
        uocOrderTaskDeal.setOrderId(orderId);
        uocOrderTaskDeal.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        uocOrderTaskDeal.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskDeal.setObjType(uocOrderTaskInst.getObjType());
        AgrCandidatesBO uecCandidatesBO = completeTaskBo.getCandidates().get(0);
        uocOrderTaskDeal.setDealId(uecCandidatesBO.getCandidateId());
        uocOrderTaskDeal.setDealName(uecCandidatesBO.getCandidateName());
        agrUocOrderTaskDeal.add(uocOrderTaskDeal);
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setAgrUocOrderTaskDeal(agrUocOrderTaskDeal);
        iAgrProcInstModel.updateTaskDeal(agrProcInstDo);

        // 3 修改任务信息
        AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo() ;
        List<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst1 = new UocOrderTaskInst();
        uocOrderTaskInst1.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskInst1.setOrderId(uocOrderTaskInst.getOrderId());
        uocOrderTaskInst1.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        String remarkOld = uocOrderTaskInst.getRemark();
        String objBusiType = remarkOld.split("_")[1];
        String remarkNew = uecCandidatesBO.getCandidateId()+"_"+objBusiType;
        uocOrderTaskInst1.setRemark(remarkNew);
        agrUocOrderTaskInst.add(uocOrderTaskInst1);
        agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
        iAgrProcInstModel.updateTask(agrProcInstDo1);
        return uocOrderTaskInst;
    }
    /**
     * 校验任务是否是待办
     */
    private UocOrderTaskInst checkTaskIsToDo(String taskId,Long orderId){
        //判断当前状态，是否为未办理
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setOrderId(orderId);
        agrTaskQryBo.setTaskInstId(taskId);
        AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
        //不存在，报错
        if (agrProcInstDo == null || CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_ERROR, "任务实例id(" + taskId + ")不存在");
        }
        //已办，报错
        if (AgrCommConstant.PROC_TASK_FINISHED.FINISHED.equals(agrProcInstDo.getAgrUocOrderTaskInst().get(0).getFinishTag())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_ERROR, "任务实例id(" +taskId + ")已完结");
        }

        return agrProcInstDo.getAgrUocOrderTaskInst().get(0);
    }
    /**
     * 更新任务为已办
     */
    private void updateTaskDone(AgrTaskInfoBO completeTaskBo,AgrTaskDealReqBO reqBO){
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        List<UocOrderTaskInst> agrUocOrderTaskInsts = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getUsername());
        uocOrderTaskInst.setDealResult(completeTaskBo.getDealResult());
        uocOrderTaskInst.setDealRemark(completeTaskBo.getDealRemark());
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
        uocOrderTaskInst.setObjId(completeTaskBo.getBusiObjId());
        uocOrderTaskInst.setObjType(completeTaskBo.getBusiObjType());

        // 审批任务设置
        if(uocOrderTaskInst.getObjType().equals(AgrCommConstant.ObjType.APPROVE)){
            AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
            agrAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
            AgrAuditOrderDo agrAuditOrderDo = iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
            String objBusiType=agrAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            String remark = reqBO.getUserId()+"_"+objBusiType+"_"+completeTaskBo.getDealResult();
            uocOrderTaskInst.setRemark(remark);
        }

        agrUocOrderTaskInsts.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInsts);
        iAgrProcInstModel.updateTask(agrProcInstDo);
    }
    /**
     * 处理已办
     */
    private UocOrderTaskInst dealDone(AgrTaskDealReqBO reqBO){
        UocOrderTaskInst uocOrderTaskInst = null;
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            for (AgrTaskInfoBO completeTaskBo:reqBO.getCompleteTaskInfos()) {
                //1 校验任务是否是待办
                uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(),reqBO.getOrderId());
                // 取数据库的业务类型和业务单据ID
                completeTaskBo.setBusiObjType(uocOrderTaskInst.getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInst.getObjId());

                //2 设置为已办
                this.updateTaskDone(completeTaskBo,reqBO);

                //3 如果审批任务所在的环节编码已完成，则把环节下面未完成的任务移到日志表（实现会签功能）
                if(completeTaskBo.getAuditStepFinish()!=null && completeTaskBo.getAuditStepFinish()){
                    AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                    agrTaskQryBo.setOrderId(reqBO.getOrderId());
                    agrTaskQryBo.setProcState(uocOrderTaskInst.getProcState());
                    agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    agrTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
                    this.deleteTask(agrTaskQryBo);
                }
            }
        }
        return uocOrderTaskInst;
    }
    /**
     * 任务删除
     */
    private void deleteTask(AgrTaskQryBo agrTaskQryBo){
        AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            List<String> taskInstIds = new ArrayList<>();
            agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                taskInstIds.add(uocOrderTaskInst.getTaskInstId());
            });
            AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo() ;
            List<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setObjId(agrTaskQryBo.getObjId());
            uocOrderTaskInst.setOrderId(agrTaskQryBo.getOrderId());
            uocOrderTaskInst.setTaskInstIds(taskInstIds);
            agrUocOrderTaskInst.add(uocOrderTaskInst);
            agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
            this.iAgrProcInstModel.deleteTask(agrProcInstDo1);
        }
    }
    /**
     * 处理流程实例信息
     */
    private void dealProInst(AgrTaskInfoBO agrTaskInfoBO,Long orderId){
        // 查询是否已存在流程实例
        AgrProcInstDo agrProcInstDoReq = new AgrProcInstDo();
        agrProcInstDoReq.setProcInstId(agrTaskInfoBO.getProcInstId());
        AgrProcInstDo agrProcInstDoRsp = iAgrProcInstModel.getProcInst(agrProcInstDoReq);
        // 不存在则新增
        if(agrProcInstDoRsp==null || StringUtils.isBlank(agrProcInstDoRsp.getProcInstId())){
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setProcInstId(agrTaskInfoBO.getProcInstId());
            agrProcInstDo.setObjId(agrTaskInfoBO.getBusiObjId());
            agrProcInstDo.setObjType(agrTaskInfoBO.getBusiObjType());
            agrProcInstDo.setOrderId(orderId);
            agrProcInstDo.setProcDefId(agrTaskInfoBO.getProcDefId());
            iAgrProcInstModel.saveProcInst(agrProcInstDo);
        }
    }
    /**
     * 任务数据转换
     */
    private UocOrderTaskInst dealTask(AgrTaskInfoBO nextTaskInfo,Long orderId){
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(orderId);
        uocOrderTaskInst.setTaskInstId(nextTaskInfo.getTaskId());
        uocOrderTaskInst.setObjId(nextTaskInfo.getBusiObjId());
        uocOrderTaskInst.setObjType(nextTaskInfo.getBusiObjType());
        uocOrderTaskInst.setProcState(nextTaskInfo.getStepId());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocOrderTaskInst.setFormUrl(nextTaskInfo.getFormUrl());
        uocOrderTaskInst.setProcDefId(nextTaskInfo.getProcDefId());
        uocOrderTaskInst.setProcInstId(nextTaskInfo.getProcInstId());
        uocOrderTaskInst.setTaskSignTag(nextTaskInfo.getTaskSignTag());
        uocOrderTaskInst.setDealResult(AgrCommConstant.TASK_DEAL_RESULT.APPROVING);
        if(uocOrderTaskInst.getTaskSignTag()==null){
            // 默认为环节任务
            uocOrderTaskInst.setTaskSignTag(AgrCommConstant.TASK_SING_TAG.TACHE_TASK);
        }
        // 审批任务设置
        if(nextTaskInfo.getBusiObjType().equals(AgrCommConstant.ObjType.APPROVE)){
            AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
            agrAuditOrderQryBo.setAuditOrderId(nextTaskInfo.getBusiObjId());
            AgrAuditOrderDo agrAuditOrderDo = iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
            String objBusiType=agrAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            if(!CollectionUtils.isEmpty(nextTaskInfo.getCandidates())){
                String remark = nextTaskInfo.getCandidates().get(0).getCandidateId();
                if(objBusiType!=null){
                    remark= remark+"_"+objBusiType;
                }
                uocOrderTaskInst.setRemark(remark);
            }
        }

        return uocOrderTaskInst;
    }
    private List<UocOrderTaskDeal> dealTaskDeal(AgrTaskInfoBO nextTaskInfo,Long orderId){
        List<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<>();
        if(!CollectionUtils.isEmpty(nextTaskInfo.getCandidates())){
            nextTaskInfo.getCandidates().forEach(agrCandidatesBO -> {
                UocOrderTaskDeal deal = new UocOrderTaskDeal();
                deal.setTaskInstId(nextTaskInfo.getTaskId());
                deal.setOrderId(orderId);
                deal.setObjId(nextTaskInfo.getBusiObjId());
                deal.setObjType(nextTaskInfo.getBusiObjType());
                deal.setDealId(agrCandidatesBO.getCandidateId());
                deal.setDealName(agrCandidatesBO.getCandidateName());
                //deal.setDealType(agrCandidatesBO.getCandidateType());
                deal.setDealClass(AgrCommConstant.TASK_DEAL_CLASS.CANDIDATE);
                uocOrderTaskDeals.add(deal);
            });
        }
        return uocOrderTaskDeals;
    }

    /**
     * 处理待办
     */
    private UocOrderTaskInst dealToDo(AgrTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            List<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<>();
            List<UocOrderTaskDeal> agrUocOrderTaskDeal = new ArrayList<>();
            reqBO.getNextTaskInfos().forEach(agrTaskInfoBO -> {
                // 如果不存在相应的流程实例，则新增一条流程实例
                dealProInst(agrTaskInfoBO, reqBO.getOrderId());
                // 任务转换
                agrUocOrderTaskInst.add(dealTask(agrTaskInfoBO, reqBO.getOrderId()));
                // 处理人转换
                agrUocOrderTaskDeal.addAll(dealTaskDeal(agrTaskInfoBO, reqBO.getOrderId()));
                // 修改协议状态
                updateStatus(agrTaskInfoBO,reqBO.getOrderId());
            });
            // 保存任务相关数据
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
            agrProcInstDo.setAgrUocOrderTaskDeal(agrUocOrderTaskDeal);
            iAgrProcInstModel.saveTask(agrProcInstDo);
            uocOrderTaskInst = agrUocOrderTaskInst.get(0);
        }
        return uocOrderTaskInst;
    }

    private void updateStatus(AgrTaskInfoBO agrTaskInfoBO,Long orderId){
        // 修改协议状态
        if(agrTaskInfoBO.getBusiObjType().equals(AgrCommConstant.ObjType.AGREEMENT)){
            AgrAgrDo agrAgrDo = new AgrAgrDo();
            agrAgrDo.setAgrId(agrTaskInfoBO.getBusiObjId());
            if(agrTaskInfoBO.getStepId().equals("AGR0001")){
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.TO_CONFIRM);
            }else if(agrTaskInfoBO.getStepId().equals("AGR0002")){
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
            }else if(agrTaskInfoBO.getStepId().equals("AGR0003")){
                AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
                agrAgrQryBo.setAgrId(orderId);
                AgrAgrDo agrAgrDo1 = iAgrAgrModel.getAgrMain(agrAgrQryBo);
                if(agrAgrDo1.getAgrStatus().equals(AgrCommConstant.AgreementStatus.TO_CONFIRM)){
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.NO_CONFIRM);
                }else {
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.REJECT);
                }

            }
            if(agrAgrDo.getAgrStatus()!=null){
                iAgrAgrModel.updateAgrMain(agrAgrDo);
            }
        }
        // 修改变更申请状态
        if(agrTaskInfoBO.getBusiObjType().equals(AgrCommConstant.ObjType.CHANGE)){
            // 查询协议变更详情
            AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new  AgrAgrChngApplyQryBo();
            agrAgrChngApplyQryBo.setAgrId(orderId);
            agrAgrChngApplyQryBo.setChngApplyId(agrTaskInfoBO.getBusiObjId());
            AgrChngApplyDo agrChngApplyDoDetail = iAgrChngApplyModel.getAgrChngApplyDetail(agrAgrChngApplyQryBo);

            // 修改协议变更状态
            AgrChngApplyDo agrChngApplyDoUpdate = new AgrChngApplyDo();
            agrChngApplyDoUpdate.setAgrId(orderId);
            agrChngApplyDoUpdate.setChngApplyId(agrTaskInfoBO.getBusiObjId());
            if(agrTaskInfoBO.getStepId().equals("AGR0001_2")){
                agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.TO_CONFIRM);
            }else if(agrTaskInfoBO.getStepId().equals("AGR0002")){
                agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.IN_AUDIT);
            }else if(agrTaskInfoBO.getStepId().equals("AGR0003")){
                if(agrChngApplyDoDetail.getChngApplyStatus().equals(AgrCommConstant.ChangeApplyStatus.TO_CONFIRM)){
                    agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.NO_CONFIRM);
                }else {
                    agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.NO_PASS);
                }
            }
            if(agrChngApplyDoUpdate.getChngApplyStatus()!=null){
                iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDoUpdate);
            }
            // 新增协议版本记录
            this.saveAgrVersion(agrChngApplyDoDetail);
        }

    }
    /**
     * 新增协议版本记录
     */
    private void saveAgrVersion(AgrChngApplyDo agrChngApplyDoDetail){
        if(!agrChngApplyDoDetail.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)
                && !agrChngApplyDoDetail.getChngType().equals(AgrCommConstant.AgreementChangeType.START)
                && !agrChngApplyDoDetail.getChngType().equals(AgrCommConstant.AgreementChangeType.TERMINATION)){
            // 查询是否存在
            AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo = new AgrGetAgrVersionListReqBo();
            agrGetAgrVersionListReqBo.setAgrId(agrChngApplyDoDetail.getAgrId());
            agrGetAgrVersionListReqBo.setChngApplyId(agrChngApplyDoDetail.getChngApplyId());
            AgrGetAgrVersionListRspBo agrGetAgrVersionListRspBo = this.iAgrAgrModel.getAgrVersionList(agrGetAgrVersionListReqBo);
            if(CollectionUtils.isEmpty(agrGetAgrVersionListRspBo.getRows())){
                AgrAgrDo agrAgrDo = new AgrAgrDo();
                List<AgrAgrVersion> agrAgrVersions = new ArrayList<>();
                AgrAgrVersion AgrAgrVersion = new AgrAgrVersion();
                AgrAgrVersion.setAgrId(agrChngApplyDoDetail.getAgrId());
                AgrAgrVersion.setAgrCode(agrChngApplyDoDetail.getAgrCode());
                AgrAgrVersion.setCreateTime(new Date());
                AgrAgrVersion.setChngType(agrChngApplyDoDetail.getChngType());
                AgrAgrVersion.setVersionStatus(AgrCommConstant.AgrVersionStatus.TO_VALID);
                AgrAgrVersion.setChngApplyCreateTime(agrChngApplyDoDetail.getCreateTime());
                AgrAgrVersion.setChngApplyNo(agrChngApplyDoDetail.getChngApplyNo());
                AgrAgrVersion.setChngApplyId(agrChngApplyDoDetail.getChngApplyId());
                agrAgrVersions.add(AgrAgrVersion);
                agrAgrDo.setAgrAgrVersion(agrAgrVersions);
                agrAgrDo.setAgrId(agrChngApplyDoDetail.getAgrId());
                this.iAgrAgrModel.saveAgrVersion(agrAgrDo);
            }
        }
    }

}
