package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 标题:AgrGetAgrDetailServiceImpl
 * 说明:TODO
 * 时间:2022/8/25 13:36
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAgrDetailServiceImpl implements AgrGetAgrDetailService {

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @Override
    public AgrGetAgrDetailRspBo getAgrDetail(AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        //1 参数检验
        this.validationParam(agrGetAgrDetailReqBo);
        //2 数据转换
        AgrAgrQryBo agrAgrQryBo = AgrRu.js(agrGetAgrDetailReqBo, AgrAgrQryBo.class);
        //3 调用协议详情查询方法
        AgrAgrDo agrDetail = this.agrAgrModel.getAgrDetail(agrAgrQryBo);
        //4 获取封装出参信息
        AgrGetAgrDetailRspBo rspBo = this.setRspBoInfo(agrDetail);
        //5 查询最新的审批流信息
        if (agrDetail != null) {
            rspBo.setProcInstId(qryProInstId(agrDetail));
            //设置父协议信息
            this.getParentAgrCode(rspBo);
            // 设置扩展对象
            AgrMainExtendBo agrMainExtendBo = AgrRu.js(agrDetail, AgrMainExtendBo.class);
            rspBo.getAgrMainSaveBO().setAgrMainExtendBo(agrMainExtendBo);
        }
        return rspBo;
    }

    /**
     * 入参检验
     *
     * @param agrGetAgrDetailReqBo agrGetAgrDetailReqBo
     */
    private void validationParam(AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        if (agrGetAgrDetailReqBo.getAgrId() == null && StringUtils.isEmpty(agrGetAgrDetailReqBo.getAgrCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]和协议编号[agrCode]不能同时为空！");
        }
    }
    private void getParentAgrCode(AgrGetAgrDetailRspBo rspBo){
        if(rspBo!=null && rspBo.getAgrMainSaveBO()!=null){
            if(rspBo.getAgrMainSaveBO().getParentAgrId()!=null){
                AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
                agrAgrQryBo.setAgrId(rspBo.getAgrMainSaveBO().getParentAgrId());
                AgrAgrDo agrAgrDo = this.agrAgrModel.getAgrMain(agrAgrQryBo);
                if(agrAgrDo!=null){
                    rspBo.getAgrMainSaveBO().setParentAgrCode(agrAgrDo.getAgrCode());
                    rspBo.setAgrMainParentBO(AgrRu.js(agrAgrDo, AgrMainDetailBo.class));
                }
            }
        }
    }

    /**
     * 查询流程实例ID
     */
    private String qryProInstId(AgrAgrDo agrDetail) {
        String procInstId = "";
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.AGREEMENT);
        agrAuditOrderQryBo.setOrderId(agrDetail.getAgrId());
        agrAuditOrderQryBo.setObjVersion(agrDetail.getAgrVersion());
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if (!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())) {
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setOrderId(agrDetail.getAgrId());
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            AgrProcInstDo agrProcInstDo1 = iAgrProcInstModel.getProcInst(agrProcInstDo);
            if (agrProcInstDo1 != null) {
                procInstId = agrProcInstDo1.getProcInstId();
            }
        }
        return procInstId;
    }


    /**
     * 封装出参信息
     */
    public AgrGetAgrDetailRspBo setRspBoInfo(AgrAgrDo agrDetail) {
        AgrGetAgrDetailRspBo rspBo = new AgrGetAgrDetailRspBo();
        if (agrDetail != null) {
            //设置协议主体信息
            AgrMainDetailBo agrMainBO = AgrRu.js(agrDetail, AgrMainDetailBo.class);
            AgrMainDetailBo agrMain = this.agrMainTransferredMeaning(agrMainBO);
            rspBo.setAgrMainSaveBO(agrMain);
            //设置协议应用范围
            rspBo.setAgrAppScopeBOs(AgrRu.jsl(agrDetail.getAgrAppScope(), AgrAppScopeBo.class));
            //设置附件信息
            rspBo.setAgrAccessoryBOs(AgrRu.jsl(agrDetail.getAgrAccessory(), AgrAccessoryBo.class));
            //设置协议类目信息
            rspBo.setAgrCataScopeBOs(AgrRu.jsl(agrDetail.getAgrCataScope(), AgrCataScopeBo.class));
            //设置付款配置
            List<AgrPayConfig> agrPayConfig = agrDetail.getAgrPayConfig();
            if (!agrPayConfig.isEmpty()) {
                List<String> pCodeList = new ArrayList<>();
                for (AgrPayConfig item : agrPayConfig) {
                    AgrPayConfigDetailBo payConfigDetailBo = AgrRu.js(item, AgrPayConfigDetailBo.class);

                    if (ObjectUtil.isNotEmpty(payConfigDetailBo.getAssign())) {
                        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.ASSIGN_PCODE);
//                        payConfigDetailBo.setAssignStr(AgrCommConstant.AssignEnum.getValueByCode(payConfigDetailBo.getAssign()));
                        //判断是否为指定日期
                        if (item.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())) {
                            //设置业务节点转义
//                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.IsAssign.getValueByCode(payConfigDetailBo.getBusiNode()));
                            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN);
                        } else if (item.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                            //设置业务节点转义
//                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.NoAssign.getValueByCode(payConfigDetailBo.getBusiNode()));
                            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.NO_ASSIGN_PCODE);
                        }
                    }

                    //设置支付方式转义
//                    payConfigDetailBo.setPayTypeStr(AgrCommConstant.PayTypeEnum.getValueByCode(payConfigDetailBo.getPayType()));
                    pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.PAY_TYPE_PCODE);
                    if (AgrCommConstant.payObj.PAY_OBJ_PURCHASE.equals(item.getPayObj())) {
                        //设置支付放转义(对采购)
//                        payConfigDetailBo.setPayObjStr(AgrCommConstant.PayObjEnum.getValueByCode(item.getPayObj()));
                        rspBo.getAgrMainSaveBO().setPayTypePur(payConfigDetailBo);
                        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE);
                    }
                    if (AgrCommConstant.payObj.PAY_OBJ_SUPPLY.equals(item.getPayObj())) {
                        //设置支付放转义(对供应)
//                        payConfigDetailBo.setPayObjStr(AgrCommConstant.PayObjEnum.getValueByCode(item.getPayObj()));
                        rspBo.getAgrMainSaveBO().setPayTypeSup(payConfigDetailBo);
                        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE);
                    }
                }
                // 查询字典
                Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
                List<AgrPayConfigDetailBo> payConfigDetailBoList = ListUtil.list(false, rspBo.getAgrMainSaveBO().getPayTypePur(), rspBo.getAgrMainSaveBO().getPayTypeSup()).stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (MapUtil.isNotEmpty(dicMap) && CollectionUtil.isNotEmpty(payConfigDetailBoList)) {
                    payConfigDetailBoList.forEach(e -> {
                        if (ObjectUtil.isNotEmpty(e.getAssign())) {
//                        payConfigDetailBo.setAssignStr(AgrCommConstant.AssignEnum.getValueByCode(payConfigDetailBo.getAssign()));
                            e.setAssignStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ASSIGN_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ASSIGN_PCODE).get(e.getAssign().toString()).getTitle());
                            //判断是否为指定日期
                            if (e.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())) {
                                //设置业务节点转义
                                e.setBusiNodeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN).get(e.getBusiNode().toString()).getTitle());
                            } else if (e.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                                //设置业务节点转义
//                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.NoAssign.getValueByCode(payConfigDetailBo.getBusiNode()));
                                e.setBusiNodeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.NO_ASSIGN_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.NO_ASSIGN_PCODE).get(e.getBusiNode().toString()).getTitle());
                            }
                        }
                        //设置支付方式转义
                        e.setPayTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.PAY_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.PAY_TYPE_PCODE).get(e.getPayType().toString()).getTitle());
                        //设置支付方转义
                        e.setPayObjStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE).get(e.getPayObj().toString()).getTitle());
                    });
                }
            }
            //调价配置信息
            AgrAdjustCfg agrAdjustCfg = agrDetail.getAgrAdjustCfg();
            if (ObjectUtil.isNotEmpty(agrAdjustCfg)) {
                rspBo.getAgrMainSaveBO().setWhetherAddPrice(agrAdjustCfg.getWhetherAddPrice());
                rspBo.getAgrMainSaveBO().setMarkupRate(agrAdjustCfg.getMarkupRate());
                rspBo.getAgrMainSaveBO().setWhetherAdjustPriceFormula(agrAdjustCfg.getWhetherAdjustPriceFormula());
                rspBo.getAgrMainSaveBO().setWhetherModifyBuyPrice(agrAdjustCfg.getWhetherModifyBuyPrice());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaId(agrAdjustCfg.getAdjustPriceFormulaId());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaName(agrAdjustCfg.getAdjustPriceFormulaName());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaValue(agrAdjustCfg.getAdjustPriceFormulaValue());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormula(agrAdjustCfg.getAdjustPriceFormula());
            }
            //外部关联设置
            List<AgrRel> agrRel = agrDetail.getAgrRel();
            rspBo.setAgrRel(AgrRu.jsl(agrRel, AgrRelBo.class));

            //协议主体扩展
            List<AgrMainExt> agrMainExt = agrDetail.getAgrMainExt();
            List<AgrMainExtBo> agrMainExtBos = AgrRu.jsl(agrMainExt, AgrMainExtBo.class);
            rspBo.getAgrMainSaveBO().setAgrMainExtBOs(agrMainExtBos);
        }
        return rspBo;
    }

    /**
     * 协议主体所需字段转义
     *
     * @return
     */
    private AgrMainDetailBo agrMainTransferredMeaning(AgrMainDetailBo rspBo) {
        List<String> pCodeList = new ArrayList<>();
        //协议模式转义  协议模式 1：平台协议 2：单位协议 默认1
        if (rspBo.getAgrMode() != null) {
//            rspBo.setAgrModeStr(AgrCommConstant.AgreementModeEnum.getValueByCode(rspBo.getAgrMode()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_MODE_PCODE);
        }
        //协议分类转义 协议分类 0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
        if (rspBo.getAgrType() != null) {
//            rspBo.setAgrTypeStr(AgrCommConstant.AgrTypeEnum.getValueByCode(rspBo.getAgrType()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_TYPE_PCODE);
        }
        //协议状态转义  协议状态 0：草稿 1：提交中  2：启用 3：停用
        if (rspBo.getAgrStatus() != null) {
//            rspBo.setAgrStatusStr(AgrCommConstant.AgreementStatusEnum.getNameByValue(rspBo.getAgrStatus()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_STATUS_PCODE);
        }
        //协议价格类型转义 价格类型 1：执行价 2：协议价 默认1
        if (rspBo.getAgrPriceType() != null) {
//            rspBo.setAgrPriceTypeStr(AgrCommConstant.AgrPriceTypeEnum.getValueByCode(rspBo.getAgrPriceType()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_PRICE_TYPE_PCODE);
        }
        //协议来源转义 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
        if (rspBo.getAgrSrc() != null) {
//            rspBo.setAgrSrcStr(AgrCommConstant.AgrSrcEnum.getValueByCode(rspBo.getAgrSrc()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE);
        }
        //交易模式转义 交易模式：1：贸易模式 2：搓合模式
        if (rspBo.getTradeMode() != null) {
//            rspBo.setTradeModeStr(AgrCommConstant.TradeModeEnum.getValueByCode(rspBo.getTradeMode()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.TRADE_MODE_PCODE);
        }
        //是否配送转义 是否配送 0:否,1是 默认值：是
        if (rspBo.getWhetherDispatch() != null) {
//            rspBo.setWhetherDispatchStr(AgrCommConstant.WhetherDispatchEnum.getValueByCode(rspBo.getWhetherDispatch()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_DISPATCH_PCODE);
        }
        //是否分配转义 是否配送 0:否,1是 默认值：是
        if (rspBo.getWhetherAssign() != null) {
//            rspBo.setWhetherAssignStr(AgrCommConstant.WhetherAssignEnum.getValueByCode(rspBo.getWhetherAssign()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN_PCODE);
        }
        //采购类别：1物资类、2施工类、3服务类
        if (rspBo.getAgreementVariety() != null) {
//            rspBo.setAgreementVarietyStr(AgrCommConstant.AgreementVarietyEnum.getValueByCode(rspBo.getAgreementVariety()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_VARIETY_PCODE);
        }
        //所属专区转义  1：电力专区，5：煤炭专区
        if (rspBo.getAgrLocation() != null) {
//            rspBo.setAgrLocationStr(AgrCommConstant.AgrLocationEnum.getValueByCode(rspBo.getAgrLocation()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_LOCATION_PCODE);
        }
        //是否商城铺货标识转义 是否商城铺货标识 1：是，0：否
        if (rspBo.getWhetherStorePlan() != null) {
//            rspBo.setWhetherStorePlanStr(AgrCommConstant.WhetherStorePlanEnum.getValueByCode(rspBo.getWhetherStorePlan()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_STORE_PLAN_PCODE);
        }
        //应用范围类型转义 选项值：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无
        if (rspBo.getScopeType() != null) {
//            rspBo.setScopeTypeStr(AgrCommConstant.ScopeTypeEnum.getValueByCode(rspBo.getScopeType()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.SCOPE_TYPE_PCODE);
        }
        //调价机制转义 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
        if (rspBo.getAdjustPrice() != null) {
//            rspBo.setAdjustPriceStr(AgrCommConstant.AdjustPriceEnum.getValueByCode(rspBo.getAdjustPrice()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.ADJUST_PRICE_PCODE);
        }
        //是否有明细标识转义  1：是，0：否
        if (rspBo.getWhetherHaveItem() != null) {
//            rspBo.setWhetherHaveItemStr(AgrCommConstant.WhetherHaveItemEnum.getValueByCode(rspBo.getWhetherHaveItem()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_HAVE_ITEM_PCODE);
        }
        //铺货方式转义
        if (rspBo.getVendorMode() != null) {
//            rspBo.setVendorModeStr(AgrCommConstant.VendorModeEnum.getValueByCode(rspBo.getVendorMode()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.VENDO_RMODE);
        }

        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
        if (MapUtil.isNotEmpty(dicMap)) {
            //协议模式转义  协议模式 1：平台协议 2：单位协议 默认1
            rspBo.setAgrModeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_MODE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_MODE_PCODE).get(rspBo.getAgrMode().toString()).getTitle());
            //协议分类转义 协议分类 0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
            rspBo.setAgrTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_TYPE_PCODE).get(rspBo.getAgrType().toString()).getTitle());
            //协议状态转义  协议状态 0：草稿 1：提交中  2：启用 3：停用
            rspBo.setAgrStatusStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_STATUS_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_STATUS_PCODE).get(rspBo.getAgrStatus().toString()).getTitle());
            //协议价格类型转义 价格类型 1：执行价 2：协议价 默认1
            rspBo.setAgrPriceTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_PRICE_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_PRICE_TYPE_PCODE).get(rspBo.getAgrPriceType().toString()).getTitle());
            //协议来源转义 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
            rspBo.setAgrSrcStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE).get(rspBo.getAgrSrc().toString()).getTitle());
            //交易模式转义 交易模式：1：贸易模式 2：搓合模式
            rspBo.setTradeModeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.TRADE_MODE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.TRADE_MODE_PCODE).get(rspBo.getTradeMode().toString()).getTitle());
            //是否配送转义 是否配送 0:否,1是 默认值：是
            rspBo.setWhetherDispatchStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_DISPATCH_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_DISPATCH_PCODE).get(rspBo.getWhetherDispatch().toString()).getTitle());
            //是否分配转义 是否配送 0:否,1是 默认值：是
            rspBo.setWhetherAssignStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN_PCODE).get(rspBo.getWhetherAssign().toString()).getTitle());
            //采购类别：1物资类、2施工类、3服务类
            rspBo.setAgreementVarietyStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_VARIETY_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_VARIETY_PCODE).get(rspBo.getAgreementVariety().toString()).getTitle());
            //所属专区转义  1：电力专区，5：煤炭专区
            rspBo.setAgrLocationStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_LOCATION_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_LOCATION_PCODE).get(rspBo.getAgrLocation().toString()).getTitle());
            //是否商城铺货标识转义 是否商城铺货标识 1：是，0：否
            rspBo.setWhetherStorePlanStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_STORE_PLAN_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_STORE_PLAN_PCODE).get(rspBo.getWhetherStorePlan().toString()).getTitle());
            //应用范围类型转义 选项值：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无
            rspBo.setScopeTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.SCOPE_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.SCOPE_TYPE_PCODE).get(rspBo.getScopeType().toString()).getTitle());
            //调价机制转义 调价机制：0：无，1：事前调价，2：事中调价 默认值：0\
            rspBo.setAdjustPriceStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ADJUST_PRICE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ADJUST_PRICE_PCODE).get(rspBo.getAdjustPrice().toString()).getTitle());
            //是否有明细标识转义  1：是，0：否
            rspBo.setAdjustPriceStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_HAVE_ITEM_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_HAVE_ITEM_PCODE).get(rspBo.getWhetherHaveItem().toString()).getTitle());
            //铺货方式转义
            rspBo.setVendorModeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.VENDO_RMODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.VENDO_RMODE).get(rspBo.getVendorMode().toString()).getTitle());
        }
        return rspBo;
    }

}
