package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemByBatchReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrItemByBatchRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：《领域服务-AGRS0024-协议明细批量修改服务》
 * @author 王洪港
 * @date 2022-09-01 15:43
 **/
@HTServiceImpl
public class AgrUpdateAgrItemByBatchServiceImpl implements AgrUpdateAgrItemByBatchService{

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrUpdateAgrItemByBatchRspBO updateAgrItemByBatch(AgrUpdateAgrItemByBatchReqBO itemByBatchReqBO) {
        //1 参数校验
        this.validateItemByBatch(itemByBatchReqBO);
        //2 调用协议明细批量修改方法
        this.batchUpdateAgrItem(itemByBatchReqBO);
        //返回结果
        return AgrRu.success(AgrUpdateAgrItemByBatchRspBO.class);
    }

    /**
     * 协议明细批量修改参数校验
     * @param itemByBatchReqBO
     */
    private void validateItemByBatch(AgrUpdateAgrItemByBatchReqBO itemByBatchReqBO){
        if (ObjectUtil.isEmpty(itemByBatchReqBO)){
            throw new BaseBusinessException("0001", "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(itemByBatchReqBO.getAgrId())){
            throw new BaseBusinessException("0001", "入参对象属性[协议ID]不能为空");
        }
    }

    /**
     * 协议明细批量修改
     * @param itemByBatchReqBO
     */
    private void batchUpdateAgrItem(AgrUpdateAgrItemByBatchReqBO itemByBatchReqBO){
        //创建参数转换
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        //设置协议ID
        agrAgrDo.setAgrId(itemByBatchReqBO.getAgrId());
        //创建协议明细
        List<AgrItem> agrItemList = new ArrayList<>();
        AgrItem agrItem = AgrRu.js(itemByBatchReqBO,AgrItem.class);
        agrItemList.add(agrItem);
        //协议明细
        agrAgrDo.setAgrItem(agrItemList);
        //调用协议明细批量修改
        this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
    }
}
