package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelReqBo;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrCandidatesBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrFlowCancelServiceImpl
 * 说明:审批流程撤销
 * 时间:2023/8/7 11:17
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrFlowCancelServiceImpl implements AgrFlowCancelService{
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    private static final String PickerConfigNo_AGR = "1";
    private static final String PickerConfigNo_AGR_CHNG = "2";
    private static final String PickerConfigNo_AGR_REFERENCE = "3";
    @Override
    public AgrFlowCancelRspBo cancelFlow(AgrFlowCancelReqBo agrFlowCancelReqBo) {
        // 入参校验
        this.validParam(agrFlowCancelReqBo);
        AgrFlowCancelRspBo rspBo = AgrRu.success(AgrFlowCancelRspBo.class);
        // 1 处理待审批任务
        List<AgrCandidatesBO> agrCandidatesBOList = this.dealAuditTodoTask(agrFlowCancelReqBo);
        rspBo.setCandidates(agrCandidatesBOList);
        // 2 如果业务流程实例Id不为空，更新业务流程任务状态
        if(!StringUtils.isEmpty(agrFlowCancelReqBo.getBusiProcInstId())){
            this.dealBusiTodoTask(agrFlowCancelReqBo);
        }
        // 3 查询协议详情
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo(); ;
        agrAgrQryBo.setAgrId(agrFlowCancelReqBo.getOrderId());
        AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        if(agrAgrDo.getAgrType().equals(AgrCommConstant.AgrType.REFERENCE_AGR)){
            // 4 如果是引用协议，则删除引用协议
            agrAgrDo.setAgrId(agrFlowCancelReqBo.getOrderId());
            this.iAgrAgrModel.deleteAgr(agrAgrDo);
            rspBo.setPickerConfigNo(PickerConfigNo_AGR_REFERENCE);
        }else {
            // 查询有多少个审批单
            AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
            agrAuditOrderQryBo.setOrderId(agrFlowCancelReqBo.getOrderId());
            agrAuditOrderQryBo.setObjId(agrFlowCancelReqBo.getObjId());
            AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);

            if(agrFlowCancelReqBo.getOrderId().equals(agrFlowCancelReqBo.getObjId())){
                // 5 如果是主协议，则更新协议状态为草稿
                agrAgrDo.setAgrId(agrFlowCancelReqBo.getOrderId());
                if(agrAuditOrderDo.getUocApprovalObj()==null || agrAuditOrderDo.getUocApprovalObj().size()==1){
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
                }else {
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.REJECT);
                }
                this.iAgrAgrModel.updateAgrMain(agrAgrDo);
                rspBo.setPickerConfigNo(PickerConfigNo_AGR);

            }else {
                // 6 协议变更申请，则更新变更申请状态未草稿
                AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
                agrChngApplyDo.setAgrId(agrFlowCancelReqBo.getOrderId());
                agrChngApplyDo.setChngApplyId(agrFlowCancelReqBo.getObjId());
                if(agrAuditOrderDo.getUocApprovalObj()==null || agrAuditOrderDo.getUocApprovalObj().size()==1){
                    agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.DRAFT);
                }else {
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.REJECT);
                }
                this.iAgrChngApplyModel.updateAgrChngApply(agrChngApplyDo);
                // 删除版本记录
                AgrAgrDo agrAgrDo1 = new AgrAgrDo();
                List<AgrAgrVersion> agrAgrVersion = new ArrayList<>();
                AgrAgrVersion agrAgrVersion1 = new AgrAgrVersion();
                agrAgrVersion1.setAgrId(agrFlowCancelReqBo.getOrderId());
                agrAgrVersion1.setChngApplyId(agrFlowCancelReqBo.getObjId());
                agrAgrVersion.add(agrAgrVersion1);
                agrAgrDo1.setAgrAgrVersion(agrAgrVersion);
                this.iAgrAgrModel.deleteAgrVersionRecord(agrAgrDo1);
                rspBo.setPickerConfigNo(PickerConfigNo_AGR_CHNG);
            }

        }
        return rspBo;
    }
    private void validParam(AgrFlowCancelReqBo agrFlowCancelReqBo){
        if(agrFlowCancelReqBo==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if(StringUtils.isEmpty(agrFlowCancelReqBo.getOrderId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议Id不能为空");
        }
        if (StringUtils.isEmpty(agrFlowCancelReqBo.getObjId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "对象Id不能为空");
        }
        if(StringUtils.isEmpty(agrFlowCancelReqBo.getAuditProcInstId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "审批流程实例Id不能为空");
        }

    }
    private void dealBusiTodoTask(AgrFlowCancelReqBo agrFlowCancelReqBo){
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        List<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(agrFlowCancelReqBo.getObjId());
        uocOrderTaskInst.setOrderId(agrFlowCancelReqBo.getOrderId());
        uocOrderTaskInst.setProcInstId(agrFlowCancelReqBo.getBusiProcInstId());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.END_TASK);
        agrUocOrderTaskInst.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
        this.iAgrProcInstModel.updateTask(agrProcInstDo);
    }
    private List<AgrCandidatesBO> dealAuditTodoTask(AgrFlowCancelReqBo agrFlowCancelReqBo) {
        List<AgrCandidatesBO> agrCandidatesBOList = new ArrayList<>();
        // 1 查询审批待办任务
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        agrTaskQryBo.setOrderId(agrFlowCancelReqBo.getOrderId());
        agrTaskQryBo.setProcInstId(agrFlowCancelReqBo.getAuditProcInstId());
        AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            List<String> taskInstIds = new ArrayList<>();
            agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                taskInstIds.add(uocOrderTaskInst.getTaskInstId());
            });
            // 2 更新待办任务状态
            AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo();
            List<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(agrTaskQryBo.getOrderId());
            uocOrderTaskInst.setTaskInstIds(taskInstIds);
            uocOrderTaskInst.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.END_TASK);
            agrUocOrderTaskInst.add(uocOrderTaskInst);
            agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
            this.iAgrProcInstModel.updateTask(agrProcInstDo1);
            // 3 查询任务处理人
            AgrTaskQryBo agrTaskQryBo1 = new AgrTaskQryBo();
            agrTaskQryBo1.setOrderId(agrFlowCancelReqBo.getOrderId());
            agrTaskQryBo1.setTaskInstIds(taskInstIds);
            AgrProcInstDo agrProcInstDo2 = this.iAgrProcInstModel.getTaskDeal(agrTaskQryBo1);
            agrProcInstDo2.getAgrUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                AgrCandidatesBO agrCandidatesBO = new AgrCandidatesBO();
                agrCandidatesBO.setCandidateId(uocOrderTaskDeal.getDealId());
                agrCandidatesBO.setCandidateName(uocOrderTaskDeal.getDealName());
                agrCandidatesBOList.add(agrCandidatesBO);
            });
        }
        return agrCandidatesBOList;
    }
}
