/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.AgrCreateReferenceAgrService;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateReferenceAgrReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateReferenceAgrRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrCreateReferenceAgrService"})
public class AgrCreateReferenceAgrServiceImpl
implements AgrCreateReferenceAgrService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"createReferenceAgr"})
    public AgrCreateReferenceAgrRspBO createReferenceAgr(@RequestBody AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO) {
        this.validateParam(agrCreateReferenceAgrReqBO);
        AgrAgrDo agrAgrDetailDo = this.getAgrDetail(agrCreateReferenceAgrReqBO.getAgrId());
        this.createAgr(agrAgrDetailDo, agrCreateReferenceAgrReqBO);
        this.copyAgrItem(agrCreateReferenceAgrReqBO.getAgrId(), agrAgrDetailDo.getAgrId());
        AgrCreateReferenceAgrRspBO rspBO = AgrRu.success(AgrCreateReferenceAgrRspBO.class);
        rspBO.setAgrId(agrAgrDetailDo.getAgrId());
        return rspBO;
    }

    private void createAgr(AgrAgrDo agrAgrDetailDo, AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO) {
        agrAgrDetailDo.setOperTime(new Date());
        agrAgrDetailDo.setAgrOperatorId(agrCreateReferenceAgrReqBO.getUserId());
        agrAgrDetailDo.setAgrOperatorName(agrCreateReferenceAgrReqBO.getUsername());
        agrAgrDetailDo.setOrgPath(agrCreateReferenceAgrReqBO.getOrgPath());
        agrAgrDetailDo.setAgrCode(agrCreateReferenceAgrReqBO.getAgrCode());
        agrAgrDetailDo.setAgrId(IdUtil.nextId());
        agrAgrDetailDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        agrAgrDetailDo.setParentAgrId(agrCreateReferenceAgrReqBO.getAgrId());
        agrAgrDetailDo.setAgrType(AgrCommConstant.AgrType.REFERENCE_AGR);
        agrAgrDetailDo.setOrgId(agrCreateReferenceAgrReqBO.getOrgId());
        agrAgrDetailDo.setOrgName(agrCreateReferenceAgrReqBO.getOrgName());
        agrAgrDetailDo.setAgrVersion("V1");
        ArrayList<AgrAppScope> agrAppScope = new ArrayList<AgrAppScope>();
        AgrAppScope bo = new AgrAppScope();
        bo.setScopeCode(agrCreateReferenceAgrReqBO.getCompanyId() + "");
        bo.setScopeName(agrCreateReferenceAgrReqBO.getCompanyName());
        bo.setScopeType(AgrCommConstant.ScopeType.DESINGATE_UNIT);
        agrAppScope.add(bo);
        agrAgrDetailDo.setAgrAppScope(agrAppScope);
        agrAgrDetailDo.setScopeType(AgrCommConstant.ScopeType.DESINGATE_UNIT);
        agrAgrDetailDo.setManagementOrgId(agrCreateReferenceAgrReqBO.getCompanyId().toString());
        agrAgrDetailDo.setManagementOrgName(agrCreateReferenceAgrReqBO.getCompanyName());
        agrAgrDetailDo.setExpDate(null);
        agrAgrDetailDo.setEffDate(null);
        agrAgrDetailDo.setCreateTime(new Date());
        agrAgrDetailDo.setAgrSignTime(new Date());
        this.iAgrAgrModel.createAgr(agrAgrDetailDo);
    }

    private void copyAgrItem(Long agrIdOld, Long agrIdNew) {
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrId(agrIdOld);
        agrItemListQryReqPageBo.setOrderBy("agr_item_id");
        agrItemListQryReqPageBo.setPageNo(1);
        agrItemListQryReqPageBo.setPageSize(1000);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        if (!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())) {
            this.saveAgrItem(agrIdNew, agrItemListQryRspPageBo.getRows());
            if (agrItemListQryRspPageBo.getTotal() > 1) {
                int total = agrItemListQryRspPageBo.getTotal();
                for (int i = 2; i <= total; ++i) {
                    agrItemListQryReqPageBo.setPageNo(i);
                    agrItemListQryReqPageBo.setPageSize(1000);
                    AgrItemListQryRspPageBo agrItemListQryRspPageBo1 = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
                    this.saveAgrItem(agrIdNew, agrItemListQryRspPageBo1.getRows());
                }
            }
        }
    }

    private void saveAgrItem(Long agrIdNew, List<AgrItem> agrItems) {
        agrItems.forEach(agrItem -> agrItem.setAgrItemId(null));
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrIdNew);
        agrAgrDo.setAgrItem(agrItems);
        this.iAgrAgrModel.saveAgrItem(agrAgrDo);
    }

    private AgrAgrDo getAgrDetail(Long agrId) {
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        return this.iAgrAgrModel.getAgrDetail(agrAgrQryBo);
    }

    private void validateParam(AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO) {
        if (agrCreateReferenceAgrReqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (agrCreateReferenceAgrReqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrCreateReferenceAgrReqBO.getAgrCode())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

