/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.impl.IAgrAgrModelImpl;
import com.tydic.dyc.agr.model.agr.sub.AgrAccessory;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrCataScope;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrService;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrUpdateAgrService"})
public class AgrUpdateAgrServiceImpl
implements AgrUpdateAgrService {
    @Autowired
    private IAgrAgrModelImpl iAgrAgrModel;

    @PostMapping(value={"updateAgr"})
    public AgrUpdateAgrRspBo updateAgr(@RequestBody AgrUpdateAgrReqBo agrUpdateAgrReqBo) {
        this.validateUpdateAgr(agrUpdateAgrReqBo);
        AgrAgrDo agrAgrDo = this.packagingData(agrUpdateAgrReqBo);
        this.iAgrAgrModel.updateAgr(agrAgrDo);
        if (AgrCommConstant.WhetherHaveItemEnum.WHETHER_HAVE_ITEM_NO.getValue().equals(agrUpdateAgrReqBo.getAgrMainSaveBO().getWhetherHaveItem())) {
            AgrAgrDo agrAgrDo1 = new AgrAgrDo();
            agrAgrDo1.setAgrId(agrUpdateAgrReqBo.getAgrId());
            this.iAgrAgrModel.deleteAgrItemByBatch(agrAgrDo1);
        }
        return AgrRu.success(AgrUpdateAgrRspBo.class);
    }

    private void validateUpdateAgr(AgrUpdateAgrReqBo agrUpdateAgrReqBo) {
        if (ObjectUtil.isEmpty((Object)agrUpdateAgrReqBo)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrUpdateAgrReqBo.getAgrAppScopeBOs())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5e94\u7528\u8303\u56f4\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private AgrAgrDo packagingData(AgrUpdateAgrReqBo agrReqBo) {
        AgrPayConfig agrPayConfig;
        AgrAgrDo agrAgrDo = AgrRu.js(agrReqBo.getAgrMainSaveBO(), AgrAgrDo.class);
        agrAgrDo.setVendorMode(agrReqBo.getAgrMainSaveBO().getSupplierMode());
        agrAgrDo.setUserId(agrReqBo.getUserId());
        agrAgrDo.setName(agrReqBo.getName());
        agrAgrDo.setUsername(agrReqBo.getUsername());
        agrAgrDo.setOperTime(new Date());
        agrAgrDo.setAgrId(agrReqBo.getAgrId());
        List<AgrCataScope> agrCataScopeList = AgrRu.jsl(agrReqBo.getAgrCataScopeBOs(), AgrCataScope.class);
        agrAgrDo.setAgrCataScope(agrCataScopeList);
        ArrayList<AgrPayConfig> agrPayConfigList = new ArrayList<AgrPayConfig>();
        if (ObjectUtil.isNotEmpty((Object)agrReqBo.getAgrMainSaveBO().getPayTypeSup()) && ObjectUtil.isNotEmpty((Object)agrReqBo.getAgrMainSaveBO().getPayTypeSup().getPayType())) {
            agrPayConfig = AgrRu.js(agrReqBo.getAgrMainSaveBO().getPayTypeSup(), AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_SUPPLY);
            agrPayConfigList.add(agrPayConfig);
        }
        if (ObjectUtil.isNotEmpty((Object)agrReqBo.getAgrMainSaveBO().getPayTypePur()) && ObjectUtil.isNotEmpty((Object)agrReqBo.getAgrMainSaveBO().getPayTypePur().getPayType())) {
            agrPayConfig = AgrRu.js(agrReqBo.getAgrMainSaveBO().getPayTypePur(), AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_PURCHASE);
            agrPayConfigList.add(agrPayConfig);
        }
        agrAgrDo.setAgrPayConfig(agrPayConfigList);
        List<AgrAppScope> agrAppScopeList = AgrRu.jsl(agrReqBo.getAgrAppScopeBOs(), AgrAppScope.class);
        agrAgrDo.setAgrAppScope(agrAppScopeList);
        List<AgrAccessory> agrAccessoryList = AgrRu.jsl(agrReqBo.getAgrAccessoryBOs(), AgrAccessory.class);
        agrAgrDo.setAgrAccessory(agrAccessoryList);
        AgrAdjustCfg agrAdjustCfg = new AgrAdjustCfg();
        agrAdjustCfg.setAdjustPrice(agrReqBo.getAgrMainSaveBO().getAdjustPrice());
        agrAgrDo.setAgrAdjustCfg(agrAdjustCfg);
        return agrAgrDo;
    }
}

