/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrMainChngDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrMainChngDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrMainChngDetailRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrMainChngDetailBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agrchange.AgrGetAgrMainChngDetailService"})
public class AgrGetAgrMainChngDetailServiceImpl
implements AgrGetAgrMainChngDetailService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrMainChngDetailServiceImpl.class);
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @PostMapping(value={"getAgrMainChngDetail"})
    public AgrGetAgrMainChngDetailRspBO getAgrMainChngDetail(@RequestBody AgrGetAgrMainChngDetailReqBO agrGetAgrMainChngDetailReqBO) {
        this.validation(agrGetAgrMainChngDetailReqBO);
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = (AgrAgrChngApplyQryBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrGetAgrMainChngDetailReqBO), AgrAgrChngApplyQryBo.class);
        log.debug("\u534f\u8bae\u4e3b\u4f53\u53d8\u66f4\u8be6\u60c5\u67e5\u8be2\u5165\u53c2[agrChngApplyDo]:{}", (Object)agrAgrChngApplyQryBo);
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        AgrGetAgrMainChngDetailRspBO agrGetAgrMainChngDetailRspBO = (AgrGetAgrMainChngDetailRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrChngApplyDo), AgrGetAgrMainChngDetailRspBO.class);
        this.agrMainTransferredMeaning(agrGetAgrMainChngDetailRspBO.getAgrMainChng());
        agrGetAgrMainChngDetailRspBO.setProcInstId(this.qryProInstId(agrGetAgrMainChngDetailReqBO.getAgrId(), agrGetAgrMainChngDetailReqBO.getChngApplyId()));
        agrGetAgrMainChngDetailRspBO.setBusiProclnstld(this.qryBusiProInstId(agrGetAgrMainChngDetailReqBO.getAgrId(), agrGetAgrMainChngDetailReqBO.getChngApplyId()));
        return agrGetAgrMainChngDetailRspBO;
    }

    private String qryBusiProInstId(Long agrId, Long chngApplyId) {
        String procInstId = "";
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setOrderId(agrId);
        agrProcInstDo.setObjId(chngApplyId);
        agrProcInstDo.setObjType(AgrCommConstant.ObjType.CHANGE);
        agrProcInstDo.setOrderBy("id desc LIMIT 1");
        AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo1 != null) {
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }

    private void validation(AgrGetAgrMainChngDetailReqBO agrGetAgrMainChngDetailReqBO) {
        if (ObjectUtil.isEmpty((Object)agrGetAgrMainChngDetailReqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrGetAgrMainChngDetailReqBO.getChngApplyId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d8\u66f4\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrGetAgrMainChngDetailReqBO.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String qryProInstId(Long agrId, Long chngApplyId) {
        String procInstId = "";
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.CHANGE);
        agrAuditOrderQryBo.setObjId(chngApplyId);
        agrAuditOrderQryBo.setOrderId(agrId);
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if (!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())) {
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setOrderId(agrId);
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            AgrProcInstDo agrProcInstDo1 = this.iAgrProcInstModel.getProcInst(agrProcInstDo);
            if (agrProcInstDo1 != null) {
                procInstId = agrProcInstDo1.getProcInstId();
            }
        }
        return procInstId;
    }

    private AgrMainChngDetailBo agrMainTransferredMeaning(AgrMainChngDetailBo rspBo) {
        Map<String, Map<String, DicDictionaryBo>> dicMap;
        ArrayList<String> pCodeList = new ArrayList<String>();
        if (rspBo.getAgrMode() != null) {
            pCodeList.add("AGR_MODE_PCODE");
        }
        if (rspBo.getAgrType() != null) {
            pCodeList.add("AGR_TYPE_PCODE");
        }
        if (rspBo.getAgrStatus() != null) {
            pCodeList.add("AGREEMENT_STATUS_PCODE");
        }
        if (rspBo.getAgrPriceType() != null) {
            pCodeList.add("AGR_PRICE_TYPE_PCODE");
        }
        if (rspBo.getAgrSrc() != null) {
            pCodeList.add("AGR_SRC_PCODE");
        }
        if (rspBo.getTradeMode() != null) {
            pCodeList.add("TRADE_MODE_PCODE");
        }
        if (rspBo.getWhetherDispatch() != null) {
            pCodeList.add("IS_DISPATCH_PCODE");
        }
        if (rspBo.getWhetherAssign() != null) {
            pCodeList.add("IS_ASSIGN_PCODE");
        }
        if (rspBo.getAgreementVariety() != null) {
            pCodeList.add("AGREEMENT_VARIETY_PCODE");
        }
        if (rspBo.getAgrLocation() != null) {
            pCodeList.add("AGR_LOCATION_PCODE");
        }
        if (rspBo.getWhetherStorePlan() != null) {
            pCodeList.add("IS_STORE_PLAN_PCODE");
        }
        if (rspBo.getScopeType() != null) {
            pCodeList.add("SCOPE_TYPE_PCODE");
        }
        if (rspBo.getAdjustPrice() != null) {
            pCodeList.add("ADJUST_PRICE_PCODE");
        }
        if (rspBo.getWhetherHaveItem() != null) {
            pCodeList.add("IS_HAVE_ITEM_PCODE");
        }
        if (rspBo.getVendorMode() != null) {
            pCodeList.add("SUPPLIER_MODE_PCODE");
        }
        if (MapUtil.isNotEmpty(dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList))) {
            rspBo.setAgrModeStr(MapUtil.isEmpty(dicMap.get("AGR_MODE_PCODE")) ? null : dicMap.get("AGR_MODE_PCODE").get(rspBo.getAgrMode().toString()).getTitle());
            rspBo.setAgrTypeStr(MapUtil.isEmpty(dicMap.get("AGR_TYPE_PCODE")) ? null : dicMap.get("AGR_TYPE_PCODE").get(rspBo.getAgrType().toString()).getTitle());
            rspBo.setAgrStatusStr(MapUtil.isEmpty(dicMap.get("AGREEMENT_STATUS_PCODE")) ? null : dicMap.get("AGREEMENT_STATUS_PCODE").get(rspBo.getAgrType().toString()).getTitle());
            rspBo.setAgrPriceTypeStr(MapUtil.isEmpty(dicMap.get("AGR_PRICE_TYPE_PCODE")) ? null : dicMap.get("AGR_PRICE_TYPE_PCODE").get(rspBo.getAgrPriceType().toString()).getTitle());
            rspBo.setAgrSrcStr(MapUtil.isEmpty(dicMap.get("AGR_SRC_PCODE")) ? null : dicMap.get("AGR_SRC_PCODE").get(rspBo.getAgrSrc().toString()).getTitle());
            rspBo.setTradeModeStr(MapUtil.isEmpty(dicMap.get("TRADE_MODE_PCODE")) ? null : dicMap.get("TRADE_MODE_PCODE").get(rspBo.getTradeMode().toString()).getTitle());
            rspBo.setWhetherDispatchStr(MapUtil.isEmpty(dicMap.get("IS_DISPATCH_PCODE")) ? null : dicMap.get("IS_DISPATCH_PCODE").get(rspBo.getWhetherDispatch().toString()).getTitle());
            rspBo.setWhetherAssignStr(MapUtil.isEmpty(dicMap.get("IS_ASSIGN_PCODE")) ? null : dicMap.get("IS_ASSIGN_PCODE").get(rspBo.getWhetherAssign().toString()).getTitle());
            rspBo.setAgreementVarietyStr(MapUtil.isEmpty(dicMap.get("AGREEMENT_VARIETY_PCODE")) ? null : dicMap.get("AGREEMENT_VARIETY_PCODE").get(rspBo.getAgreementVariety().toString()).getTitle());
            rspBo.setWhetherStorePlanStr(MapUtil.isEmpty(dicMap.get("IS_STORE_PLAN_PCODE")) ? null : dicMap.get("IS_STORE_PLAN_PCODE").get(rspBo.getWhetherStorePlan().toString()).getTitle());
            rspBo.setScopeTypeStr(MapUtil.isEmpty(dicMap.get("SCOPE_TYPE_PCODE")) ? null : dicMap.get("SCOPE_TYPE_PCODE").get(rspBo.getScopeType().toString()).getTitle());
            rspBo.setAdjustPriceStr(MapUtil.isEmpty(dicMap.get("ADJUST_PRICE_PCODE")) ? null : dicMap.get("ADJUST_PRICE_PCODE").get(rspBo.getAdjustPrice().toString()).getTitle());
            rspBo.setAdjustPriceStr(MapUtil.isEmpty(dicMap.get("IS_HAVE_ITEM_PCODE")) ? null : dicMap.get("IS_HAVE_ITEM_PCODE").get(rspBo.getWhetherHaveItem().toString()).getTitle());
            rspBo.setVendorModeStr(MapUtil.isEmpty(dicMap.get("SUPPLIER_MODE_PCODE")) ? null : dicMap.get("SUPPLIER_MODE_PCODE").get(rspBo.getVendorMode().toString()).getTitle());
        }
        return rspBo;
    }
}

