/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrFlowCancelService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelReqBo;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrCandidatesBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskInfoBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrFlowCancelService"})
public class AgrFlowCancelServiceImpl
implements AgrFlowCancelService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;
    private static final String PickerConfigNo_AGR = "1";
    private static final String PickerConfigNo_AGR_CHNG = "2";
    private static final String PickerConfigNo_AGR_REFERENCE = "3";

    @PostMapping(value={"cancelFlow"})
    public AgrFlowCancelRspBo cancelFlow(@RequestBody AgrFlowCancelReqBo agrFlowCancelReqBo) {
        this.validParam(agrFlowCancelReqBo);
        AgrFlowCancelRspBo rspBo = AgrRu.success(AgrFlowCancelRspBo.class);
        List<AgrTaskInfoBO> cancelTaskInfos = this.dealAuditTodoTask(agrFlowCancelReqBo);
        rspBo.setCancelTaskInfos(cancelTaskInfos);
        if (!StringUtils.isEmpty((Object)agrFlowCancelReqBo.getBusiProcInstId())) {
            this.dealBusiTodoTask(agrFlowCancelReqBo);
        }
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrFlowCancelReqBo.getOrderId());
        AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        if (agrAgrDo.getAgrType().equals(AgrCommConstant.AgrType.REFERENCE_AGR)) {
            agrAgrDo.setAgrId(agrFlowCancelReqBo.getOrderId());
            this.iAgrAgrModel.deleteAgr(agrAgrDo);
            rspBo.setPickerConfigNo(PickerConfigNo_AGR_REFERENCE);
        } else if (agrFlowCancelReqBo.getOrderId().equals(agrFlowCancelReqBo.getObjId())) {
            agrAgrDo.setAgrId(agrFlowCancelReqBo.getOrderId());
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
            this.iAgrAgrModel.updateAgrMain(agrAgrDo);
            rspBo.setPickerConfigNo(PickerConfigNo_AGR);
        } else {
            AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
            agrChngApplyDo.setAgrId(agrFlowCancelReqBo.getOrderId());
            agrChngApplyDo.setChngApplyId(agrFlowCancelReqBo.getObjId());
            agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.DRAFT);
            this.iAgrChngApplyModel.updateAgrChngApply(agrChngApplyDo);
            AgrAgrDo agrAgrDo1 = new AgrAgrDo();
            ArrayList<AgrAgrVersion> agrAgrVersion = new ArrayList<AgrAgrVersion>();
            AgrAgrVersion agrAgrVersion1 = new AgrAgrVersion();
            agrAgrVersion1.setAgrId(agrFlowCancelReqBo.getOrderId());
            agrAgrVersion1.setChngApplyId(agrFlowCancelReqBo.getObjId());
            agrAgrVersion.add(agrAgrVersion1);
            agrAgrDo1.setAgrAgrVersion(agrAgrVersion);
            this.iAgrAgrModel.deleteAgrVersionRecord(agrAgrDo1);
            rspBo.setPickerConfigNo(PickerConfigNo_AGR_CHNG);
        }
        return rspBo;
    }

    private void validParam(AgrFlowCancelReqBo agrFlowCancelReqBo) {
        if (agrFlowCancelReqBo == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrFlowCancelReqBo.getOrderId())) {
            throw new BaseBusinessException("0001", "\u534f\u8baeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrFlowCancelReqBo.getObjId())) {
            throw new BaseBusinessException("0001", "\u5bf9\u8c61Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrFlowCancelReqBo.getAuditProcInstId())) {
            throw new BaseBusinessException("0001", "\u5ba1\u6279\u6d41\u7a0b\u5b9e\u4f8bId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealBusiTodoTask(AgrFlowCancelReqBo agrFlowCancelReqBo) {
        AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo();
        ArrayList<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(agrFlowCancelReqBo.getOrderId());
        uocOrderTaskInst.setProcInstId(agrFlowCancelReqBo.getBusiProcInstId());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.taskFinishFLag.NOT_FINISH);
        agrUocOrderTaskInst.add(uocOrderTaskInst);
        agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
        this.iAgrProcInstModel.deleteTask(agrProcInstDo1);
    }

    private List<AgrTaskInfoBO> dealAuditTodoTask(AgrFlowCancelReqBo agrFlowCancelReqBo) {
        ArrayList<AgrTaskInfoBO> cancelTaskInfos = new ArrayList<AgrTaskInfoBO>();
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setOrderId(agrFlowCancelReqBo.getOrderId());
        agrTaskQryBo.setProcInstId(agrFlowCancelReqBo.getAuditProcInstId());
        AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
        ArrayList<String> taskInstIds = new ArrayList<String>();
        HashMap<String, AgrTaskInfoBO> cancelTaskInfoMap = new HashMap<String, AgrTaskInfoBO>();
        for (UocOrderTaskInst uocOrderTaskInst : agrProcInstDo.getAgrUocOrderTaskInst()) {
            taskInstIds.add(uocOrderTaskInst.getTaskInstId());
            AgrTaskInfoBO bo = AgrRu.js(uocOrderTaskInst, AgrTaskInfoBO.class);
            bo.setTaskId(uocOrderTaskInst.getTaskInstId());
            if (uocOrderTaskInst.getFinishTag().equals(AgrCommConstant.taskFinishFLag.NOT_FINISH)) {
                bo.setFinish(Boolean.valueOf(false));
            } else {
                bo.setFinish(Boolean.valueOf(true));
            }
            cancelTaskInfoMap.put(bo.getTaskId(), bo);
        }
        AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo();
        ArrayList<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(agrTaskQryBo.getOrderId());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.taskFinishFLag.NOT_FINISH);
        agrUocOrderTaskInst.add(uocOrderTaskInst);
        agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
        this.iAgrProcInstModel.deleteTask(agrProcInstDo1);
        AgrTaskQryBo agrTaskQryBo1 = new AgrTaskQryBo();
        agrTaskQryBo1.setOrderId(agrFlowCancelReqBo.getOrderId());
        agrTaskQryBo1.setTaskInstIds(taskInstIds);
        AgrProcInstDo agrProcInstDo2 = this.iAgrProcInstModel.getTaskDeal(agrTaskQryBo1);
        Map<String, List<UocOrderTaskDeal>> uocOrderTaskDealMap = agrProcInstDo2.getAgrUocOrderTaskDeal().stream().collect(Collectors.groupingBy(UocOrderTaskDeal::getTaskInstId));
        uocOrderTaskDealMap.keySet().forEach(key -> {
            AgrTaskInfoBO agrTaskInfoBO = (AgrTaskInfoBO)cancelTaskInfoMap.get(key);
            ArrayList candidates = new ArrayList();
            ((List)uocOrderTaskDealMap.get(key)).forEach(uocOrderTaskDeal -> {
                AgrCandidatesBO agrCandidatesBO = new AgrCandidatesBO();
                agrCandidatesBO.setCandidateId(uocOrderTaskDeal.getDealId());
                agrCandidatesBO.setCandidateName(uocOrderTaskDeal.getDealName());
                candidates.add(agrCandidatesBO);
            });
            agrTaskInfoBO.setCandidates(candidates);
        });
        return cancelTaskInfos;
    }
}

