/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrGetAgrAdjustIChngItemListService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAdjustIChngItemListReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAdjustIChngItemListRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrItemAdjustChngBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrGetAgrAdjustIChngItemListService"})
public class AgrGetAgrAdjustIChngItemListServiceImpl
implements AgrGetAgrAdjustIChngItemListService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrAdjustIChngItemListServiceImpl.class);
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"getAgrAdjustIChngItemList"})
    public AgrGetAgrAdjustIChngItemListRspBO getAgrAdjustIChngItemList(@RequestBody AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        this.validation(reqBo);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.getAgrItemByPage(reqBo);
        AgrItemChngListQryRspPageBo agrItemChngListQryRspPageBo = this.getAgrItemChngByItemIds(agrItemListQryRspPageBo, reqBo);
        AgrGetAgrAdjustIChngItemListRspBO rspBO = AgrRu.js(agrItemListQryRspPageBo, AgrGetAgrAdjustIChngItemListRspBO.class);
        rspBO.setRows(this.packageRsp(agrItemListQryRspPageBo, agrItemChngListQryRspPageBo));
        return rspBO;
    }

    private List<AgrItemAdjustChngBo> packageRsp(AgrItemListQryRspPageBo itemBo, AgrItemChngListQryRspPageBo itemChngBo) {
        List<AgrItemAdjustChngBo> rows = AgrRu.jsl(itemBo.getRows(), AgrItemAdjustChngBo.class);
        if (!CollectionUtils.isEmpty(rows)) {
            Map<Object, Object> tempMap = new HashMap();
            if (!CollectionUtils.isEmpty(itemChngBo.getRows())) {
                tempMap = itemChngBo.getRows().stream().collect(Collectors.toMap(AgrItemChng::getAgrItemId, agrItemChng -> agrItemChng));
            }
            for (AgrItemAdjustChngBo agrItemAdjustChngBo : rows) {
                AgrItemChng agrItemChng2 = (AgrItemChng)tempMap.get(agrItemAdjustChngBo.getAgrItemId());
                if (agrItemAdjustChngBo.getWhetherOil() != null) {
                    agrItemAdjustChngBo.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode((Integer)agrItemAdjustChngBo.getWhetherOil()));
                }
                agrItemAdjustChngBo.setNewbuyNumber(agrItemAdjustChngBo.getBuyNumber());
                agrItemAdjustChngBo.setNewbuyPrice(agrItemAdjustChngBo.getBuyPrice());
                agrItemAdjustChngBo.setNewbuyPriceSum(agrItemAdjustChngBo.getBuyPriceSum());
                agrItemAdjustChngBo.setNewmarkupRate(agrItemAdjustChngBo.getMarkupRate());
                agrItemAdjustChngBo.setNewsalePrice(agrItemAdjustChngBo.getSalePrice());
                agrItemAdjustChngBo.setNewsalePriceSum(agrItemAdjustChngBo.getSalePriceSum());
                agrItemAdjustChngBo.setAgrItemChngId(agrItemAdjustChngBo.getAgrItemChngId());
                if (agrItemChng2 == null) continue;
                if (agrItemChng2.getBuyNumber() != null) {
                    agrItemAdjustChngBo.setNewbuyNumber(agrItemChng2.getBuyNumber());
                }
                if (agrItemChng2.getBuyPrice() != null) {
                    agrItemAdjustChngBo.setNewbuyPrice(agrItemChng2.getBuyPrice());
                }
                if (agrItemChng2.getBuyPriceSum() != null) {
                    agrItemAdjustChngBo.setNewbuyPriceSum(agrItemChng2.getBuyPriceSum());
                }
                if (agrItemChng2.getMarkupRate() != null) {
                    agrItemAdjustChngBo.setNewmarkupRate(agrItemChng2.getMarkupRate());
                }
                if (agrItemChng2.getSalePrice() != null) {
                    agrItemAdjustChngBo.setNewsalePrice(agrItemChng2.getSalePrice());
                }
                if (agrItemChng2.getSalePriceSum() != null) {
                    agrItemAdjustChngBo.setNewsalePriceSum(agrItemChng2.getSalePriceSum());
                }
                if (agrItemChng2.getAgrItemChngId() == null) continue;
                agrItemAdjustChngBo.setAgrItemChngId(agrItemChng2.getAgrItemChngId());
            }
        }
        return rows;
    }

    private AgrItemChngListQryRspPageBo getAgrItemChngByItemIds(AgrItemListQryRspPageBo agrItemListQryRspPageBo, AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        List<AgrItem> agrItems;
        ArrayList<Long> agrItemIds = new ArrayList<Long>();
        if (ObjectUtil.isNotEmpty((Object)agrItemListQryRspPageBo) && !CollectionUtils.isEmpty(agrItems = agrItemListQryRspPageBo.getRows())) {
            agrItems.stream().map(AgrItem::getAgrItemId).forEach(agrItemId -> agrItemIds.add((Long)agrItemId));
        }
        if (agrItemIds.size() > 0) {
            AgrItemChngListQryReqPageBo agrItemChngListQryReqPageBo = AgrRu.js(reqBo, AgrItemChngListQryReqPageBo.class);
            agrItemChngListQryReqPageBo.setAgrItemIds(agrItemIds);
            AgrItemChngListQryRspPageBo agrItemChngListQryRspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(agrItemChngListQryReqPageBo);
            return agrItemChngListQryRspPageBo;
        }
        return null;
    }

    private AgrItemListQryRspPageBo getAgrItemByPage(AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBo, AgrItemListQryReqPageBo.class);
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(reqBo.getAgrId());
        agrAgrChngApplyQryBo.setChngApplyId(reqBo.getChngApplyId());
        AgrChngApplyDo rspDo = this.iAgrChngApplyModel.getAgrChngApplyDetail(agrAgrChngApplyQryBo);
        if (rspDo != null && StringUtils.hasText((String)rspDo.getAgrVersion())) {
            agrItemListQryReqPageBo.setAgrVersion(rspDo.getAgrVersion());
        }
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        return agrItemListQryRspPageBo;
    }

    private void validation(AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getChngApplyId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d8\u66f4\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPageNo())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5f53\u524d\u9875]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPageSize())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6bcf\u9875\u6761\u6570]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

