/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrSyncUccService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrScopeSyncBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSkuChangePriceBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrSyncUccService"})
public class AgrSyncUccServiceImpl
implements AgrSyncUccService {
    private static final Logger log = LoggerFactory.getLogger(AgrSyncUccServiceImpl.class);
    @Value(value="${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;
    @Value(value="${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;
    @Resource(name="agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"dealAgrSyncUcc"})
    public AgrSyncUccRspBO dealAgrSyncUcc(@RequestBody AgrSyncUccReqBO agrSyncUccReqBO) {
        this.validParam(agrSyncUccReqBO);
        String messageContent = "";
        switch (agrSyncUccReqBO.getSyncType()) {
            case 1: {
                messageContent = this.toFrozen(agrSyncUccReqBO);
                break;
            }
            case 2: {
                messageContent = this.toInvalid(agrSyncUccReqBO);
                break;
            }
            case 3: {
                messageContent = this.toUpShelf(agrSyncUccReqBO);
                break;
            }
            case 4: {
                messageContent = this.syncScope(agrSyncUccReqBO);
                break;
            }
            case 5: {
                this.syncAgrItemAjustPrice(agrSyncUccReqBO);
                break;
            }
            case 6: {
                this.syncAgrItemDelete(agrSyncUccReqBO);
                break;
            }
        }
        this.sendMsg(messageContent);
        return AgrRu.success(AgrSyncUccRspBO.class);
    }

    private void sendMsg(String content) {
        if (StringUtils.hasText((String)content)) {
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + content);
            this.agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(this.agrSkuChangeTopic, this.agrSkuChangeTag, content));
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u6210\u529f");
        }
    }

    private void syncAgrItemDelete(AgrSyncUccReqBO agrSyncUccReqBO) {
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(agrSyncUccReqBO.getAgrId());
        reqPageBo.setChngApplyId(agrSyncUccReqBO.getChngApplyId());
        reqPageBo.setItemChngType(AgrCommConstant.AgreementSkuChangeType.DELETE);
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if (null != rspPageBo && !CollectionUtils.isEmpty(rspPageBo.getRows())) {
            this.syncAgrItemDeleteData(rspPageBo.getRows(), agrSyncUccReqBO.getAgrId());
            if (rspPageBo.getTotal() > 1) {
                int total = rspPageBo.getTotal();
                for (int i = 2; i <= total; ++i) {
                    reqPageBo.setPageNo(1);
                    reqPageBo.setPageSize(1000);
                    AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                    this.syncAgrItemDeleteData(rspPageBo1.getRows(), agrSyncUccReqBO.getAgrId());
                }
            }
        }
    }

    private void syncAgrItemDeleteData(List<AgrItemChng> agrItemChngs, Long agrId) {
        ArrayList agreementSkuIds = new ArrayList();
        agrItemChngs.forEach(agrItemChng -> agreementSkuIds.add(agrItemChng.getAgrItemId()));
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        agreementIds.add(agrId);
        content.put("agreementIds", agreementIds);
        content.put("operType", AgrCommConstant.AgrChangeOperType.CHANGE_NEW_STATUS);
        content.put("agreementSkuIds", agreementSkuIds);
        this.sendMsg(JSON.toJSONString(content));
    }

    private void syncAgrItemAjustPrice(AgrSyncUccReqBO agrSyncUccReqBO) {
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(agrSyncUccReqBO.getAgrId());
        reqPageBo.setChngApplyId(agrSyncUccReqBO.getChngApplyId());
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if (null != rspPageBo && !CollectionUtils.isEmpty(rspPageBo.getRows())) {
            this.syncAgrItemAjustPriceData(rspPageBo.getRows(), agrSyncUccReqBO.getAgrId());
            if (rspPageBo.getTotal() > 1) {
                int total = rspPageBo.getTotal();
                for (int i = 2; i <= total; ++i) {
                    reqPageBo.setPageNo(1);
                    reqPageBo.setPageSize(1000);
                    AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                    this.syncAgrItemAjustPriceData(rspPageBo1.getRows(), agrSyncUccReqBO.getAgrId());
                }
            }
        }
    }

    private void syncAgrItemAjustPriceData(List<AgrItemChng> agrItemChngs, Long agrId) {
        ArrayList skuChangePriceBOs = new ArrayList();
        agrItemChngs.forEach(agrItemChng -> {
            AgrSkuChangePriceBO agrSkuChangePriceBO = new AgrSkuChangePriceBO();
            agrSkuChangePriceBO.setAgreementId(agrId);
            agrSkuChangePriceBO.setAgreementSkuId(agrItemChng.getAgrItemId());
            try {
                agrSkuChangePriceBO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrItemChng.getSalePrice()));
                agrSkuChangePriceBO.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrItemChng.getBuyPrice()));
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
            skuChangePriceBOs.add(agrSkuChangePriceBO);
        });
        HashMap content = new HashMap();
        content.put("skuChangePriceBOs", skuChangePriceBOs);
        this.sendMsg(JSON.toJSONString(content));
    }

    private String syncScope(AgrSyncUccReqBO agrSyncUccReqBO) {
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(agrSyncUccReqBO.getAgrId());
        agrAgrChngApplyQryBo.setChngApplyId(agrSyncUccReqBO.getChngApplyId());
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        if (null != agrChngApplyDo && !CollectionUtils.isEmpty(agrChngApplyDo.getAgrAppScopeChng())) {
            ArrayList appScopes = new ArrayList();
            agrChngApplyDo.getAgrAppScopeChng().forEach(agrAppScopeChng -> appScopes.add(agrAppScopeChng.getScopeCode()));
            ArrayList<AgrAgrScopeSyncBO> agrScopeSyncBOs = new ArrayList<AgrAgrScopeSyncBO>();
            AgrAgrScopeSyncBO agrAgrScopeSyncBO = new AgrAgrScopeSyncBO();
            agrAgrScopeSyncBO.setAgreementId(agrSyncUccReqBO.getAgrId());
            agrAgrScopeSyncBO.setScopeCodes(((Object)appScopes).toString());
            agrScopeSyncBOs.add(agrAgrScopeSyncBO);
            HashMap<String, ArrayList<AgrAgrScopeSyncBO>> content = new HashMap<String, ArrayList<AgrAgrScopeSyncBO>>();
            content.put("agrScopeSyncBOs", agrScopeSyncBOs);
            return JSON.toJSONString(content);
        }
        return null;
    }

    private String toUpShelf(AgrSyncUccReqBO agrSyncUccReqBO) {
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        content.put("operType", AgrCommConstant.AgrChangeOperType.RECOVER_STATUS);
        content.put("agreementIds", agreementIds);
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
        return JSON.toJSONString(content);
    }

    private String toInvalid(AgrSyncUccReqBO agrSyncUccReqBO) {
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        content.put("operType", AgrCommConstant.AgrChangeOperType.CHANGE_NEW_STATUS);
        content.put("agreementIds", agreementIds);
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
        return JSON.toJSONString(content);
    }

    private String toFrozen(AgrSyncUccReqBO agrSyncUccReqBO) {
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        content.put("operType", AgrCommConstant.AgrChangeOperType.CHANGE_NEW_STATUS);
        content.put("agreementIds", agreementIds);
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
        return JSON.toJSONString(content);
    }

    private void validParam(AgrSyncUccReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSyncType() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2syncType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2agrId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

