package com.tydic.dyc.agr.model.sysDicDictionary.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.repository.AgrDictionaryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description: IAgrDictionaryModelImpl
 * @Author: the_xhl
 * @Date: 2023-07-27
 */
@Service
public class IAgrDictionaryModelImpl implements IAgrDictionaryModel {

    @Autowired
    private AgrDictionaryRepository agrDictionaryRepository;

    @Override
    public List<DicDictionaryBo> selectByPCodeList(List<String> pCodeList) {
        return this.agrDictionaryRepository.selectByPCodeList(pCodeList);
    }

    @Override
    public Map<String, Map<String, DicDictionaryBo>> selectByPCodeListToMap(List<String> pCodeList) {
        List<DicDictionaryBo> dicDictionaryBoList = this.selectByPCodeList(pCodeList);
        if (CollectionUtil.isEmpty(dicDictionaryBoList)) {
            return new HashMap<>(16);
        }
        return dicDictionaryBoList.stream().collect(Collectors.groupingBy(DicDictionaryBo::getPCode, Collectors.toMap(DicDictionaryBo::getCode, Function.identity(), (a, b) -> a)));
    }
}
